/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.buttons;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.packmenu.PackMenu;
import dev.shadowsoffire.packmenu.buttons.ScreenType;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public interface ButtonAction
extends CodecProvider<ButtonAction>,
Button.OnPress {
    public static final CodecMap<ButtonAction> CODEC = new CodecMap("Button Action");

    public static void registerCodecs() {
        ButtonAction.register("connect_to_server", ConnectToServer.CODEC);
        ButtonAction.register("reload", Reload.CODEC);
        ButtonAction.register("open_screen", OpenScreen.CODEC);
        ButtonAction.register("open_url", OpenUrl.CODEC);
        ButtonAction.register("quit", Quit.CODEC);
        ButtonAction.register("none", None.CODEC);
    }

    private static void register(String id, Codec<? extends ButtonAction> codec) {
        CODEC.register(PackMenu.loc(id), codec);
    }

    public record ConnectToServer(String ipAddress) implements ButtonAction
    {
        public static Codec<ConnectToServer> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("ip_address").forGetter(ConnectToServer::ipAddress)).apply((Applicative)inst, ConnectToServer::new));

        public Codec<ConnectToServer> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
            Minecraft mc = Minecraft.getInstance();
            ServerData data = ConnectToServer.getOrCreateServerData(this.ipAddress());
            ServerAddress addr = ServerAddress.parseString((String)this.ipAddress());
            ConnectScreen.startConnecting((Screen)mc.screen, (Minecraft)mc, (ServerAddress)addr, (ServerData)data, (boolean)false, null);
        }

        public static ServerData getOrCreateServerData(String ip) {
            JoinMultiplayerScreen scn = new JoinMultiplayerScreen(Minecraft.getInstance().screen);
            scn.init(Minecraft.getInstance(), 0, 0);
            ServerList list = scn.getServers();
            for (int i = 0; i < list.size(); ++i) {
                ServerData data = list.get(i);
                if (!data.ip.equals(ip)) continue;
                return data;
            }
            ServerData data = new ServerData("Packmenu Managed Server", ip, ServerData.Type.OTHER);
            list.add(data, true);
            list.save();
            return data;
        }
    }

    public record Reload() implements ButtonAction
    {
        public static Codec<Reload> CODEC = Codec.unit(Reload::new);

        public Codec<Reload> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
            PackMenu.loadConfig();
            Minecraft.getInstance().reloadResourcePacks();
        }
    }

    public record OpenScreen(ScreenType type) implements ButtonAction
    {
        public static Codec<OpenScreen> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ScreenType.CODEC.fieldOf("screen").forGetter(OpenScreen::type)).apply((Applicative)inst, OpenScreen::new));

        public Codec<OpenScreen> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen(this.type.createNewScreen(mc.screen));
        }
    }

    public record OpenUrl(String url) implements ButtonAction
    {
        public static Codec<OpenUrl> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("url").forGetter(OpenUrl::url)).apply((Applicative)inst, OpenUrl::new));

        public Codec<OpenUrl> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
            Util.getPlatform().openUri(this.url);
        }
    }

    public record Quit() implements ButtonAction
    {
        public static Codec<Quit> CODEC = Codec.unit(Quit::new);

        public Codec<Quit> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
            Minecraft.getInstance().stop();
        }
    }

    public record None() implements ButtonAction
    {
        public static Codec<None> CODEC = Codec.unit(None::new);

        public Codec<None> getCodec() {
            return CODEC;
        }

        public void onPress(Button button) {
        }
    }
}

