/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.validator;

import com.hollingsworth.arsnouveau.api.item.ISpellModifier;
import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.BaseSpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.ScanningSpellValidator;
import dev.qther.ars_controle.spell.filter.FilterBinary;
import dev.qther.ars_controle.spell.filter.IAdaptiveFilter;
import java.util.List;
import javax.annotation.Nullable;

public class BinaryFilterValidator
extends ScanningSpellValidator<Context> {
    public static final ISpellValidator INSTANCE = new BinaryFilterValidator();

    protected Context initContext() {
        return new Context();
    }

    protected void digestSpellPart(Context context, int position, AbstractSpellPart spellPart, List<SpellValidationError> validationErrors) {
        switch (context.state.ordinal()) {
            case 0: {
                FilterBinary filter;
                if (!(spellPart instanceof FilterBinary)) break;
                context.filter = filter = (FilterBinary)spellPart;
                context.state = State.FOUND_BINARY_FILTER;
                break;
            }
            case 1: {
                if (spellPart instanceof IAdaptiveFilter) {
                    validationErrors.add((SpellValidationError)new NoChainingAdaptiveFilters(position, (AbstractSpellPart)context.filter));
                    return;
                }
                if (spellPart instanceof AbstractFilter) {
                    context.state = State.FOUND_FIRST;
                    break;
                }
                validationErrors.add((SpellValidationError)new InvalidBinaryFilter(position, (AbstractSpellPart)context.filter));
                context.state = State.LOOKING;
                break;
            }
            case 2: {
                if (spellPart instanceof IAdaptiveFilter) {
                    validationErrors.add((SpellValidationError)new NoChainingAdaptiveFilters(position, (AbstractSpellPart)context.filter));
                    return;
                }
                if (spellPart instanceof ISpellModifier) {
                    return;
                }
                if (!(spellPart instanceof AbstractFilter)) {
                    validationErrors.add((SpellValidationError)new InvalidBinaryFilter(position, (AbstractSpellPart)context.filter));
                }
                context.state = State.LOOKING;
            }
        }
    }

    public static class Context {
        @Nullable
        FilterBinary filter;
        State state = State.LOOKING;
    }

    static enum State {
        LOOKING,
        FOUND_BINARY_FILTER,
        FOUND_FIRST;

    }

    private static class NoChainingAdaptiveFilters
    extends BaseSpellValidationError {
        public NoChainingAdaptiveFilters(int position, AbstractSpellPart spellPart) {
            super(position, spellPart, "binary_filters.no_chaining", new AbstractSpellPart[]{spellPart});
        }
    }

    private static class InvalidBinaryFilter
    extends BaseSpellValidationError {
        public InvalidBinaryFilter(int position, AbstractSpellPart spellPart) {
            super(position, spellPart, "binary_filters.next_two_not_filters", new AbstractSpellPart[]{spellPart});
        }
    }
}

