/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.packets.serverbound;

import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.item.RemoteItem;
import dev.qther.ars_controle.registry.ACRegistry;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class PacketSetRemoteSelectionMode
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSetRemoteSelectionMode> TYPE = new CustomPacketPayload.Type(ArsControle.prefix("set_remote_selection_mode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetRemoteSelectionMode> CODEC = StreamCodec.ofMember(PacketSetRemoteSelectionMode::toBytes, PacketSetRemoteSelectionMode::new);
    public RemoteItem.SelectionModeSlot slot;

    public PacketSetRemoteSelectionMode(RemoteItem.SelectionModeSlot slot) {
        this.slot = slot;
    }

    public PacketSetRemoteSelectionMode(FriendlyByteBuf buf) {
        this.slot = (RemoteItem.SelectionModeSlot)buf.readEnum(RemoteItem.SelectionModeSlot.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.slot);
    }

    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == ACRegistry.Items.REMOTE.get()) {
            RemoteItem.RemoteData data = RemoteItem.RemoteData.fromItemStack(stack);
            GlobalPos corner = this.slot == RemoteItem.SelectionModeSlot.MULTIPLE ? (GlobalPos)data.firstCorner().orElse(null) : null;
            data.withSelectionMode(this.slot).withFirstCorner(corner).write(stack);
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.selection_mode.set", (Object[])new Object[]{this.slot.translatable()}));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

