/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.item;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.ANEventBus;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.packets.serverbound.PacketSetRemoteLockMode;
import dev.qther.ars_controle.packets.serverbound.PacketSetRemoteSelectionMode;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteItem
extends ModItem
implements IRadialProvider {
    public RemoteItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public Component getName(ItemStack stack) {
        RemoteData data = (RemoteData)stack.get(ACRegistry.Components.REMOTE);
        if (data != null && data.targetName.getContents() != PlainTextContents.EMPTY) {
            return Component.translatable((String)"item.ars_controle.remote.with_target", (Object[])new Object[]{data.targetName});
        }
        return Component.translatable((String)"item.ars_controle.remote");
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (ctx.getLevel().isClientSide() || ctx.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getItemInHand();
        BlockPos blockPos = ctx.getClickedPos();
        BlockState state = level.getBlockState(blockPos);
        Block block = state.getBlock();
        if (ANEventBus.post((Event)new BlockEvent.BreakEvent(level, blockPos, state, player))) {
            return InteractionResult.FAIL;
        }
        RemoteData data = RemoteData.fromItemStack(stack);
        if (data.isEmpty()) {
            if (player.isShiftKeyDown()) {
                RemoteData.fromBlock(block, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)blockPos), data.lockedFirst, data.multiple, data.firstCorner.orElse(null)).write(stack);
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.set_target", (Object[])new Object[]{blockPos.toShortString(), level.dimension().location().toString()}));
                return InteractionResult.SUCCESS;
            }
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.none"));
            return InteractionResult.FAIL;
        }
        if (data.block.isPresent()) {
            GlobalPos globalPos = data.block.get();
            BlockPos targetPos = globalPos.pos();
            ResourceKey targetDim = globalPos.dimension();
            ServerLevel targetLevel = Cached.getLevelByKey((ResourceKey<Level>)targetDim);
            if (targetLevel == null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
                return InteractionResult.FAIL;
            }
            BlockEntity tile = targetLevel.getBlockEntity(targetPos);
            if (tile instanceof IWandable) {
                IWandable wandable = (IWandable)tile;
                if (data.multiple) {
                    if (data.firstCorner.isEmpty() || !data.firstCorner.get().dimension().equals(level.dimension())) {
                        data.withFirstCorner(new GlobalPos(level.dimension(), blockPos)).write(stack);
                        return InteractionResult.SUCCESS;
                    }
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)data.firstCorner.get().pos(), (BlockPos)blockPos)) {
                        if (data.lockedFirst) {
                            wandable.onFirstConnection(new GlobalPos(level.dimension(), pos), ctx.getClickedFace(), null, player);
                            continue;
                        }
                        wandable.onLastConnection(new GlobalPos(level.dimension(), pos), ctx.getClickedFace(), null, player);
                    }
                    data.withFirstCorner(null).write(stack);
                } else if (data.lockedFirst) {
                    wandable.onFirstConnection(new GlobalPos(level.dimension(), blockPos), ctx.getClickedFace(), null, player);
                } else {
                    wandable.onLastConnection(new GlobalPos(level.dimension(), blockPos), ctx.getClickedFace(), null, player);
                }
                return InteractionResult.CONSUME;
            }
            if (data.multiple) {
                if (data.firstCorner.isEmpty() || !data.firstCorner.get().dimension().equals(level.dimension())) {
                    data.withFirstCorner(new GlobalPos(level.dimension(), blockPos)).write(stack);
                    return InteractionResult.SUCCESS;
                }
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)data.firstCorner.get().pos(), (BlockPos)blockPos)) {
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (!(blockEntity instanceof IWandable)) continue;
                    IWandable wandable = (IWandable)blockEntity;
                    if (data.lockedFirst) {
                        wandable.onLastConnection(globalPos, ctx.getClickedFace(), null, player);
                        continue;
                    }
                    wandable.onFirstConnection(globalPos, ctx.getClickedFace(), null, player);
                }
                data.withFirstCorner(null).write(stack);
            } else {
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                if (blockEntity instanceof IWandable) {
                    IWandable wandable = (IWandable)blockEntity;
                    if (data.lockedFirst) {
                        wandable.onLastConnection(globalPos, ctx.getClickedFace(), null, player);
                    } else {
                        wandable.onFirstConnection(globalPos, ctx.getClickedFace(), null, player);
                    }
                }
            }
            return InteractionResult.CONSUME;
        }
        if (data.entity.isPresent()) {
            Entity targetEntity = Cached.getEntityByUUID(data.entity.get());
            if (targetEntity instanceof IWandable) {
                IWandable wandable = (IWandable)targetEntity;
                if (data.multiple) {
                    if (data.firstCorner.isEmpty() || !data.firstCorner.get().dimension().equals(level.dimension())) {
                        data.withFirstCorner(new GlobalPos(level.dimension(), blockPos)).write(stack);
                        return InteractionResult.SUCCESS;
                    }
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)data.firstCorner.get().pos(), (BlockPos)blockPos)) {
                        if (data.lockedFirst) {
                            wandable.onFirstConnection(new GlobalPos(level.dimension(), pos), ctx.getClickedFace(), null, player);
                            continue;
                        }
                        wandable.onLastConnection(new GlobalPos(level.dimension(), pos), ctx.getClickedFace(), null, player);
                    }
                    data.withFirstCorner(null).write(stack);
                } else if (data.lockedFirst) {
                    wandable.onFirstConnection(new GlobalPos(level.dimension(), blockPos), ctx.getClickedFace(), null, player);
                } else {
                    wandable.onLastConnection(new GlobalPos(level.dimension(), blockPos), ctx.getClickedFace(), null, player);
                }
                return InteractionResult.CONSUME;
            }
            if (targetEntity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)targetEntity;
                if (data.multiple) {
                    if (data.firstCorner.isEmpty() || !data.firstCorner.get().dimension().equals(level.dimension())) {
                        data.withFirstCorner(new GlobalPos(level.dimension(), blockPos)).write(stack);
                        return InteractionResult.SUCCESS;
                    }
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)data.firstCorner.get().pos(), (BlockPos)blockPos)) {
                        BlockEntity blockEntity = level.getBlockEntity(pos);
                        if (!(blockEntity instanceof IWandable)) continue;
                        IWandable wandable = (IWandable)blockEntity;
                        if (data.lockedFirst) {
                            wandable.onLastConnection(null, ctx.getClickedFace(), le, player);
                            continue;
                        }
                        wandable.onFirstConnection(null, ctx.getClickedFace(), le, player);
                    }
                    data.withFirstCorner(null).write(stack);
                } else {
                    BlockEntity blockEntity = level.getBlockEntity(blockPos);
                    if (blockEntity instanceof IWandable) {
                        IWandable wandable = (IWandable)blockEntity;
                        if (data.lockedFirst) {
                            wandable.onLastConnection(null, ctx.getClickedFace(), le, player);
                        } else {
                            wandable.onFirstConnection(null, ctx.getClickedFace(), le, player);
                        }
                    }
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack _stack, Player player, LivingEntity entity, InteractionHand hand) {
        Level level = player.level();
        if (level.isClientSide() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        RemoteData data = RemoteData.fromItemStack(stack);
        if (data.isEmpty()) {
            if (player.isShiftKeyDown()) {
                if (entity.isAlive()) {
                    RemoteData.fromEntity((Entity)entity, data.lockedFirst, data.multiple, data.firstCorner.orElse(null)).write(stack);
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.set_target", (Object[])new Object[]{entity.getName(), level.dimension().location().toString()}));
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.none"));
            return InteractionResult.FAIL;
        }
        if (data.block.isPresent()) {
            GlobalPos globalPos = data.block.get();
            BlockPos targetPos = globalPos.pos();
            ResourceKey targetDim = globalPos.dimension();
            ServerLevel targetLevel = Cached.getLevelByKey((ResourceKey<Level>)targetDim);
            if (targetLevel == null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
                return InteractionResult.FAIL;
            }
            BlockEntity tile = targetLevel.getBlockEntity(targetPos);
            if (tile instanceof IWandable) {
                IWandable wandable = (IWandable)tile;
                if (data.lockedFirst) {
                    wandable.onLastConnection(null, null, entity, player);
                } else {
                    wandable.onFirstConnection(null, null, entity, player);
                }
                return InteractionResult.CONSUME;
            }
            if (entity instanceof IWandable) {
                IWandable wandable = (IWandable)entity;
                if (data.lockedFirst) {
                    wandable.onFirstConnection(globalPos, null, null, player);
                } else {
                    wandable.onLastConnection(globalPos, null, null, player);
                }
                return InteractionResult.CONSUME;
            }
        } else if (data.entity.isPresent()) {
            Entity targetEntity = Cached.getEntityByUUID(data.entity.get());
            if (targetEntity instanceof IWandable) {
                IWandable wandable = (IWandable)targetEntity;
                if (data.lockedFirst) {
                    wandable.onLastConnection(null, null, entity, player);
                } else {
                    wandable.onFirstConnection(null, null, entity, player);
                }
                return InteractionResult.CONSUME;
            }
            if (targetEntity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)targetEntity;
                if (entity instanceof IWandable) {
                    IWandable wandable = (IWandable)entity;
                    if (data.lockedFirst) {
                        wandable.onFirstConnection(null, null, le, player);
                    } else {
                        wandable.onLastConnection(null, null, le, player);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        RemoteData data = RemoteData.fromItemStack(stack);
        tooltip2.add((Component)Component.translatable((String)"ars_controle.remote.lock_mode.tooltip", (Object[])new Object[]{data.lockedFirst ? Component.translatable((String)"ars_controle.remote.lock_mode.first") : Component.translatable((String)"ars_controle.remote.lock_mode.last")}));
        tooltip2.add((Component)Component.translatable((String)"ars_controle.remote.selection_mode.tooltip", (Object[])new Object[]{data.multiple ? Component.translatable((String)"ars_controle.remote.selection_mode.multiple") : Component.translatable((String)"ars_controle.remote.selection_mode.single")}));
    }

    public void onRadialKeyPressed(ItemStack stack, Player player) {
        RadialMenu menu = player.isShiftKeyDown() ? new RadialMenu(slot -> Networking.sendToServer((CustomPacketPayload)new PacketSetRemoteLockMode(LockModeSlot.VALUES[slot])), List.of(LockModeSlot.LOCKED_FIRST.asSlot(), LockModeSlot.LOCKED_LAST.asSlot()), RenderUtils::drawString, 0) : new RadialMenu(slot -> Networking.sendToServer((CustomPacketPayload)new PacketSetRemoteSelectionMode(SelectionModeSlot.VALUES[slot])), List.of(SelectionModeSlot.SINGLE.asSlot(), SelectionModeSlot.MULTIPLE.asSlot()), RenderUtils::drawString, 0);
        Client.setScreen((RadialMenu<String>)menu);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(stack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pIsSelected || pLevel.isClientSide || pLevel.getGameTime() % 5L != 0L || !(pEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)pEntity;
        RemoteData data = RemoteData.fromItemStack(stack);
        Entity highlighter = null;
        if (data.block.isPresent()) {
            ServerLevel level = Cached.getLevelByKey((ResourceKey<Level>)data.block.get().dimension());
            if (level != null) {
                highlighter = level.getBlockEntity(data.block.get().pos());
            }
        } else if (data.entity.isPresent() && player.getServer() != null) {
            highlighter = Cached.getEntityByUUID(data.entity.get());
        }
        if (highlighter != null) {
            if (highlighter instanceof IDimensionalHighlighter) {
                IDimensionalHighlighter dim = (IDimensionalHighlighter)highlighter;
                Networking.sendToPlayerClient((CustomPacketPayload)new HighlightAreaPacket(dim.getWandHighlight(pLevel, new ArrayList<ColorPos>()), 10), (ServerPlayer)player);
            } else if (highlighter instanceof IWandable) {
                IWandable wandable = (IWandable)highlighter;
                Networking.sendToPlayerClient((CustomPacketPayload)new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList()), 10), (ServerPlayer)player);
            }
        }
    }

    public record RemoteData(@NotNull Optional<GlobalPos> block, @NotNull Optional<UUID> entity, boolean lockedFirst, boolean multiple, @NotNull Optional<GlobalPos> firstCorner, @NotNull Component targetName) {
        public static final Codec<RemoteData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("block").forGetter(RemoteData::block), (App)UUIDUtil.CODEC.optionalFieldOf("entity").forGetter(RemoteData::entity), (App)Codec.BOOL.fieldOf("locked_first").forGetter(RemoteData::lockedFirst), (App)Codec.BOOL.fieldOf("multiple").forGetter(RemoteData::multiple), (App)GlobalPos.CODEC.optionalFieldOf("first_corner").forGetter(RemoteData::firstCorner), (App)ComponentSerialization.CODEC.fieldOf("target_name").forGetter(RemoteData::targetName)).apply((Applicative)instance, RemoteData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RemoteData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), RemoteData::block, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), RemoteData::entity, (StreamCodec)ByteBufCodecs.BOOL, RemoteData::lockedFirst, (StreamCodec)ByteBufCodecs.BOOL, RemoteData::multiple, (StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), RemoteData::firstCorner, (StreamCodec)ComponentSerialization.STREAM_CODEC, RemoteData::targetName, RemoteData::new);

        public static RemoteData empty() {
            return new RemoteData(Optional.empty(), Optional.empty(), true, false, Optional.empty(), (Component)Component.empty());
        }

        public static RemoteData fromItemStack(@NotNull ItemStack stack) {
            return (RemoteData)stack.getOrDefault(ACRegistry.Components.REMOTE, (Object)RemoteData.empty());
        }

        public static RemoteData fromBlock(@NotNull Block block, @NotNull GlobalPos pos, boolean lockedFirst, boolean multiple, @Nullable GlobalPos firstCorner) {
            return new RemoteData(Optional.of(pos), Optional.empty(), lockedFirst, multiple, Optional.ofNullable(firstCorner), (Component)block.getName());
        }

        public static RemoteData fromEntity(@NotNull Entity entity, boolean lockedFirst, boolean multiple, @Nullable GlobalPos firstCorner) {
            return new RemoteData(Optional.empty(), Optional.of(entity.getUUID()), lockedFirst, multiple, Optional.ofNullable(firstCorner), entity.getName());
        }

        public RemoteData withBlock(@Nullable GlobalPos pos) {
            return new RemoteData(Optional.ofNullable(pos), this.entity, this.lockedFirst, this.multiple, this.firstCorner, this.targetName);
        }

        public RemoteData withEntity(@Nullable Entity entity) {
            return new RemoteData(this.block, Optional.ofNullable(entity).map(Entity::getUUID), this.lockedFirst, this.multiple, this.firstCorner, this.targetName);
        }

        public RemoteData withLockingMode(LockModeSlot slot) {
            return new RemoteData(this.block, this.entity, slot == LockModeSlot.LOCKED_FIRST, this.multiple, this.firstCorner, this.targetName);
        }

        public RemoteData withSelectionMode(SelectionModeSlot slot) {
            return new RemoteData(this.block, this.entity, this.lockedFirst, slot == SelectionModeSlot.MULTIPLE, this.firstCorner, this.targetName);
        }

        public RemoteData withFirstCorner(@Nullable GlobalPos corner) {
            return new RemoteData(this.block, this.entity, this.lockedFirst, this.multiple, Optional.ofNullable(corner), this.targetName);
        }

        public RemoteData cleared() {
            return new RemoteData(Optional.empty(), Optional.empty(), this.lockedFirst, this.multiple, Optional.empty(), (Component)Component.empty());
        }

        public boolean isEmpty() {
            return this.block.isEmpty() && this.entity.isEmpty();
        }

        public RemoteData write(@NotNull ItemStack stack) {
            return (RemoteData)stack.set(ACRegistry.Components.REMOTE, (Object)this);
        }
    }

    public static enum LockModeSlot {
        LOCKED_FIRST("ars_controle.remote.lock_mode.first"),
        LOCKED_LAST("ars_controle.remote.lock_mode.last");

        public static final LockModeSlot[] VALUES;
        public final String key;

        private LockModeSlot(String key) {
            this.key = key;
        }

        public Component translatable() {
            return Component.translatable((String)"ars_controle.remote.lock_mode.radial", (Object[])new Object[]{Component.translatable((String)this.key)});
        }

        public RadialMenuSlot<String> asSlot() {
            return new RadialMenuSlot(this.translatable().getString(), (Object)this.key);
        }

        static {
            VALUES = LockModeSlot.values();
        }
    }

    public static enum SelectionModeSlot {
        SINGLE("ars_controle.remote.selection_mode.single"),
        MULTIPLE("ars_controle.remote.selection_mode.multiple");

        public static final SelectionModeSlot[] VALUES;
        public final String key;

        private SelectionModeSlot(String key) {
            this.key = key;
        }

        public Component translatable() {
            return Component.translatable((String)this.key);
        }

        public RadialMenuSlot<String> asSlot() {
            return new RadialMenuSlot(this.translatable().getString(), (Object)this.key);
        }

        static {
            VALUES = SelectionModeSlot.values();
        }
    }

    private static class Client {
        private Client() {
        }

        public static void setScreen(RadialMenu<String> menu) {
            Minecraft.getInstance().setScreen((Screen)new GuiRadialMenu(menu));
        }
    }
}

