/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle;

import dev.qther.ars_controle.cc.ACPeripherals;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.config.ACStartupConfig;
import dev.qther.ars_controle.datagen.ACSetup;
import dev.qther.ars_controle.item.PortableBrazierRelayItem;
import dev.qther.ars_controle.packets.ACNetworking;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="ars_controle")
public class ArsControle {
    public static final String MODID = "ars_controle";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ars_controle");

    public ArsControle(IEventBus bus, ModContainer container) {
        ACRegistry.register(bus);
        bus.addListener(ACSetup::gatherData);
        bus.addListener(ACNetworking::register);
        bus.addListener(this::onRegisterCapabilities);
        bus.addListener(ACStartupConfig::onLoad);
        NeoForge.EVENT_BUS.addListener(ArsControle::onServerStopped);
        container.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ACStartupConfig.SPEC);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ACServerConfig.SPEC);
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ACRegistry.Tiles.SCROLL_HOLDER.get(), (tile, context) -> tile.getItemHandler());
        if (ModList.get().isLoaded("computercraft")) {
            ACPeripherals.register(event);
        }
        block2: for (BlockCapability cap : BlockCapability.getAll()) {
            for (Class<?> c : ACStartupConfig.STARTUP.SCRYERS_LINKAGE_BLACKLISTED_CLASSES) {
                if (!cap.typeClass().isAssignableFrom(c)) continue;
                continue block2;
            }
            try {
                BlockCapability erased = cap;
                event.registerBlockEntity(erased, (BlockEntityType)ACRegistry.Tiles.SCRYERS_LINKAGE.get(), (linkage, context) -> {
                    Pair<Level, BlockPos> info = linkage.getTargetInfo();
                    if (info == null) {
                        return null;
                    }
                    Level level = (Level)info.first();
                    BlockPos block = (BlockPos)info.second();
                    return level.getCapability(erased, block, context);
                });
            }
            catch (ClassCastException e) {
                LOGGER.error("Could not register capability for linkage", (Throwable)e);
            }
        }
    }

    public static void onServerStopped(ServerStoppedEvent event) {
        Cached.ENTITIES_BY_UUID.invalidateAll();
        PortableBrazierRelayItem.clearCache();
    }
}

