/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Color {
    public int red;
    public int green;
    public int blue;
    public int hex;
    public static final Codec<Color> RGB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("red").forGetter(Color::red), (App)Codec.INT.fieldOf("green").forGetter(Color::green), (App)Codec.INT.fieldOf("blue").forGetter(Color::blue)).apply((Applicative)instance, Color::new));
    public static final Codec<Color> HEX_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(Color::hex)).apply((Applicative)instance, Color::new));
    public static final Codec<Color> CODEC = Codec.either(RGB_CODEC, HEX_CODEC).xmap(either -> either.left().orElseGet(() -> (Color)either.right().orElseThrow()), Either::left);
    public static final StreamCodec<ByteBuf, Color> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Color::hex, Color::new);

    public Color(int color) {
        this.hex = color;
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
    }

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.updateHexFromRGB();
    }

    public static Color black() {
        return new Color(0);
    }

    public static Color white() {
        return new Color(0xFFFFFF);
    }

    public int hex() {
        return this.hex;
    }

    private int red() {
        return this.red;
    }

    private int green() {
        return this.green;
    }

    private int blue() {
        return this.blue;
    }

    public void reset() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.hex = 0;
    }

    public void set(Color to) {
        this.red = to.red;
        this.green = to.green;
        this.blue = to.blue;
        this.hex = to.hex;
    }

    public boolean equals(Object obj) {
        boolean obj_equals = super.equals(obj);
        if (obj instanceof Color) {
            return this.red == ((Color)obj).red && this.green == ((Color)obj).green && this.blue == ((Color)obj).blue;
        }
        return obj_equals;
    }

    public void updateHexFromRGB() {
        this.hex = this.red << 16 | this.green << 8 | this.blue;
    }

    public void setMixColor(Color base_color, Map<Power, Integer> powers, int total_visible_power, int max_power) {
        this.reset();
        for (Power p : powers.keySet()) {
            if (p == null || p.invisible) continue;
            Color pow_color = p.getColor();
            float pow_weight = (float)powers.get(p).intValue() / (float)total_visible_power;
            this.red += (int)((float)pow_color.red * pow_weight);
            this.green += (int)((float)pow_color.green * pow_weight);
            this.blue += (int)((float)pow_color.blue * pow_weight);
        }
        float tint_alpha = (float)total_visible_power / (float)max_power;
        this.red = (int)((float)base_color.red * (1.0f - tint_alpha) + (float)this.red * tint_alpha);
        this.green = (int)((float)base_color.green * (1.0f - tint_alpha) + (float)this.green * tint_alpha);
        this.blue = (int)((float)base_color.blue * (1.0f - tint_alpha) + (float)this.blue * tint_alpha);
        this.updateHexFromRGB();
    }

    public String toString() {
        return String.format("%02x", this.hex());
    }
}

