/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.components.ReactionFlaskContents;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReactionFlaskModifyRecipe
extends CustomRecipe {
    public ReactionFlaskModifyRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        boolean has_reaction_flask = false;
        boolean has_volt_cell = false;
        boolean has_duplicate_items = false;
        for (ItemStack stack : input.items()) {
            if (stack.is((Item)ReactiveItems.REACTION_FLASK.get()) && stack.has((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get())) {
                if (has_reaction_flask) {
                    has_duplicate_items = true;
                } else {
                    has_reaction_flask = true;
                }
            }
            if (!stack.is((Item)ReactiveItems.VOLT_CELL.get())) continue;
            if (has_volt_cell) {
                has_duplicate_items = true;
                continue;
            }
            has_volt_cell = true;
        }
        return has_reaction_flask && has_volt_cell && !has_duplicate_items;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ReactionFlaskContents contents = new ReactionFlaskContents(Map.of(), false);
        for (ItemStack stack : input.items()) {
            if (!stack.is((Item)ReactiveItems.REACTION_FLASK.get())) continue;
            contents = (ReactionFlaskContents)stack.get((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get());
        }
        if (contents == null) {
            throw new RuntimeException("Reaction flask with no contents was allowed to assemble a flask modify recipe");
        }
        ItemStack flask = ((ReactionFlaskItem)((Object)ReactiveItems.REACTION_FLASK.get())).getDefaultInstance();
        flask.set((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get(), (Object)new ReactionFlaskContents(contents.powers(), true));
        return flask;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remaining_items = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining_items.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!stack.is((Item)ReactiveItems.VOLT_CELL.get())) continue;
            remaining_items.set(i, (Object)stack.getItem().getDefaultInstance());
        }
        return remaining_items;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.REACTION_FLASK_MODIFY_RECIPE_SERIALIZER.get();
    }
}

