/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.components.ReactionFlaskContents;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReactionFlaskCraftingRecipe
extends CustomRecipe {
    public static final TagKey<Item> POWER_BOTTLE_TAG = ItemTags.create((ResourceLocation)ReactiveMod.location("power_bottles"));

    public ReactionFlaskCraftingRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static Map<Power, Integer> getPowerBalance(CraftingInput input) {
        HashMap<Power, Integer> powers = new HashMap<Power, Integer>();
        for (ItemStack stack : input.items()) {
            for (Power power : (Registry)Powers.POWERS.getRegistry().get()) {
                if (!power.matchesBottle(stack)) continue;
                powers.put(power, WorldSpecificValues.BOTTLE_RETURN.get());
            }
        }
        return powers;
    }

    private boolean matchOneWide(CraftingInput input) {
        if (!input.getItem(0, 0).is((Item)ReactiveItems.INERT_CRYSTAL.get()) || !input.getItem(0, 2).is((Item)ReactiveItems.GOLD_THREAD.get())) {
            return false;
        }
        return input.getItem(1, 0).is(POWER_BOTTLE_TAG);
    }

    private boolean matchTwoWide(CraftingInput input) {
        if (!(input.getItem(0, 0).is((Item)ReactiveItems.INERT_CRYSTAL.get()) && input.getItem(0, 2).is((Item)ReactiveItems.GOLD_THREAD.get()) || input.getItem(1, 0).is((Item)ReactiveItems.INERT_CRYSTAL.get()) && input.getItem(1, 2).is((Item)ReactiveItems.GOLD_THREAD.get()))) {
            return false;
        }
        return input.getItem(0, 1).is(POWER_BOTTLE_TAG) && input.getItem(1, 1).is(POWER_BOTTLE_TAG);
    }

    private boolean matchThreeWide(CraftingInput input) {
        if (!input.getItem(1, 0).is((Item)ReactiveItems.INERT_CRYSTAL.get()) || !input.getItem(1, 2).is((Item)ReactiveItems.GOLD_THREAD.get())) {
            return false;
        }
        return input.getItem(0, 1).is(POWER_BOTTLE_TAG) && input.getItem(1, 1).is(POWER_BOTTLE_TAG) && input.getItem(2, 1).is(POWER_BOTTLE_TAG);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        if (input.height() == 3 && input.width() == 1) {
            return this.matchOneWide(input);
        }
        if (input.height() == 3 && input.width() == 2) {
            return this.matchTwoWide(input);
        }
        if (input.height() == 3 && input.width() == 3) {
            return this.matchThreeWide(input);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        Map<Power, Integer> powers = ReactionFlaskCraftingRecipe.getPowerBalance(input);
        ItemStack result = ((ReactionFlaskItem)((Object)ReactiveItems.REACTION_FLASK.get())).getDefaultInstance();
        result.set((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get(), (Object)new ReactionFlaskContents(powers, false));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        boolean already_removed_one_bottle = false;
        NonNullList filtered_remaining_items = NonNullList.create();
        for (ItemStack stack : super.getRemainingItems((RecipeInput)input)) {
            if (!already_removed_one_bottle && stack.is((Item)ReactiveItems.QUARTZ_BOTTLE.get())) {
                already_removed_one_bottle = true;
                filtered_remaining_items.add((Object)ItemStack.EMPTY);
                continue;
            }
            filtered_remaining_items.add((Object)stack);
        }
        return filtered_remaining_items;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.REACTION_FLASK_RECIPE_SERIALIZER.get();
    }
}

