/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBearer;
import dev.hyperlynx.reactive.recipes.CrucibleRecipeInput;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PrecipitateRecipe
implements Recipe<CrucibleRecipeInput> {
    protected final String group;
    protected final ItemStack product;
    protected final List<Power> reagents;
    final int cost;
    final int minimum;
    final int reagent_count;
    public final boolean needs_electricity;

    public PrecipitateRecipe(String group, ItemStack product, List<Power> reagents, int min, int cost, int reagent_count, boolean needs_electricity) {
        this.group = group;
        this.product = product;
        this.reagents = reagents;
        this.minimum = min;
        this.cost = cost;
        this.reagent_count = reagent_count;
        this.needs_electricity = needs_electricity;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    private boolean powerMet(CrucibleRecipeInput input) {
        ArrayList<Power> sorted_reagents = WorldSpecificValue.shuffle(this.reagents.hashCode() + "-" + this.product.hashCode() + "_reagent_order", this.reagents);
        int power_level = 0;
        int iterations = 0;
        boolean has_all_reagents = true;
        for (Power p : sorted_reagents) {
            if (iterations > this.reagent_count) break;
            if (input.getPowerLevel(p) == 0) {
                has_all_reagents = false;
                break;
            }
            power_level += input.getPowerLevel(p);
            ++iterations;
        }
        return has_all_reagents && power_level > this.minimum;
    }

    public ItemStack apply(PowerBearer bearer) {
        if (this.cost > 0) {
            for (Power p : this.reagents) {
                bearer.expendPower(p, this.cost / this.reagent_count);
            }
        }
        ItemStack result = this.product.copy();
        result.setCount(result.getCount());
        return result;
    }

    public boolean matches(@NotNull CrucibleRecipeInput input, @NotNull Level level) {
        return this.powerMet(input);
    }

    @NotNull
    public ItemStack assemble(@NotNull CrucibleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.product.copy();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.product;
    }

    public List<Power> getReagents() {
        return this.reagents;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getReagentCount() {
        return this.reagent_count;
    }

    public boolean isElectricityRequired() {
        return this.needs_electricity;
    }

    public int getCost() {
        return this.cost;
    }

    public ItemStack getProduct() {
        return this.product;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.PRECIPITATE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ReactiveRecipes.PRECIPITATE_RECIPE_TYPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }
}

