/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class DissolveRecipeSerializer
implements RecipeSerializer<DissolveRecipe> {
    public static final MapCodec<DissolveRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"dissolve").forGetter(Recipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("reactant").forGetter(DissolveRecipe::getReactant), (App)ItemStack.STRICT_CODEC.fieldOf("product").forGetter(DissolveRecipe::getProduct), (App)Codec.BOOL.optionalFieldOf("needs_electricity", (Object)false).forGetter(DissolveRecipe::isElectricityRequired)).apply((Applicative)instance, DissolveRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DissolveRecipe> STREAM_CODEC = StreamCodec.of(DissolveRecipeSerializer::toNetwork, DissolveRecipeSerializer::fromNetwork);

    public MapCodec<DissolveRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, DissolveRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull DissolveRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.reactant);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.product);
        buffer.writeBoolean(recipe.needs_electricity);
    }

    @NotNull
    public static DissolveRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        Ingredient reactant = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack product = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        boolean needs_electricity = buffer.readBoolean();
        return new DissolveRecipe("dissolve", reactant, product, needs_electricity);
    }
}

