/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.recipes.CrucibleRecipeInput;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DissolveRecipe
implements Recipe<CrucibleRecipeInput> {
    protected final Ingredient reactant;
    protected final ItemStack product;
    public final boolean needs_electricity;

    public DissolveRecipe(String ignored, Ingredient reactant, ItemStack product, boolean needs_electricity) {
        this.reactant = reactant;
        this.product = product;
        this.needs_electricity = needs_electricity;
    }

    public boolean matches(@NotNull CrucibleRecipeInput input, @NotNull Level level) {
        for (ItemStack i : this.reactant.getItems()) {
            if (!input.getItem().is(i.getItem())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(CrucibleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ItemStack result = this.product.copy();
        result.setCount(this.product.getCount() * input.getItem().getCount());
        return result;
    }

    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.product;
    }

    public ItemStack getProduct() {
        return this.product;
    }

    public Ingredient getReactant() {
        return this.reactant;
    }

    public boolean isElectricityRequired() {
        return this.needs_electricity;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.DISSOLVE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }
}

