/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.CatalystEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.net.ReactionPagePayload;
import dev.hyperlynx.reactive.net.ReactionPageRequestPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ReactionPageServer {
    public static void handlePageRequest(ReactionPageRequestPayload payload, IPayloadContext context) {
        String page = ReactionPageServer.makePageFor(context.player().level(), payload.alias());
        ReactiveMod.LOGGER.debug("Sending formula for {} to {}", (Object)payload.alias(), (Object)context.player().getName().getString());
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ReactionPagePayload(payload.alias(), page), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static String makePageFor(Level level, String alias) {
        Reaction reaction = ReactiveMod.REACTION_MAN.get(level, alias);
        StringBuilder formula = new StringBuilder();
        if (reaction != null) {
            formula.append(Component.translatable((String)"docs.reactive.powers_label").getString());
            for (Power power : reaction.getReagents().keySet()) {
                formula.append(power.getName()).append("$(br)");
            }
            if (reaction instanceof CurseAssimilationReaction) {
                formula.append(Component.translatable((String)"docs.reactive.curse_label").getString());
            }
            if (reaction.getReagents().isEmpty()) {
                formula.append(Component.translatable((String)"docs.reactive.any_label").getString());
            }
            formula.append(Component.translatable((String)"docs.reactive.stimulus_label").getString());
            switch (reaction.getStimulus()) {
                case NONE: {
                    formula.append(Component.translatable((String)"text.reactive.none").getString());
                    break;
                }
                case GOLD_SYMBOL: {
                    formula.append(Component.translatable((String)"block.reactive.gold_symbol").getString());
                    break;
                }
                case ELECTRIC: {
                    formula.append(Component.translatable((String)"text.reactive.electric_charge").getString());
                    break;
                }
                case END_CRYSTAL: {
                    formula.append(Component.translatable((String)"item.minecraft.end_crystal").getString());
                    break;
                }
                case NO_ELECTRIC: {
                    formula.append(Component.translatable((String)"text.reactive.lack_of").getString()).append(Component.translatable((String)"text.reactive.electric_charge").getString());
                    break;
                }
                case NO_END_CRYSTAL: {
                    formula.append(Component.translatable((String)"text.reactive.lack_of").getString()).append(Component.translatable((String)"item.minecraft.end_crystal").getString());
                    break;
                }
                case NO_IRON_SYMBOL: {
                    formula.append(Component.translatable((String)"text.reactive.lack_of").getString()).append(Component.translatable((String)"block.reactive.iron_symbol").getString());
                }
            }
            if (reaction instanceof CatalystEffectReaction) {
                CatalystEffectReaction catre = (CatalystEffectReaction)reaction;
                formula.append(Component.translatable((String)"docs.reactive.catalyst_label").getString());
                formula.append(catre.getCatalyst().getDescription().getString());
            }
        }
        return formula.toString();
    }
}

