/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.mixin;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Phantom.class})
public abstract class PhantomMixin {
    Optional<BlockPos> symbol_maybe = Optional.empty();
    int symbol_cache_ticker = 0;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        ++this.symbol_cache_ticker;
        if (this.symbol_cache_ticker > (Integer)ConfigMan.COMMON.crucibleTickDelay.get()) {
            this.symbol_maybe = BlockPos.findClosestMatch((BlockPos)((Phantom)this).blockPosition(), (int)10, (int)10, blockPos -> ((Phantom)this).level().getBlockState(blockPos).is((Block)ReactiveBlocks.IRON_SYMBOL.get()));
            this.symbol_cache_ticker = 0;
        }
        if (this.symbol_maybe.isPresent()) {
            ((Phantom)this).hurt(((Phantom)this).level().damageSources().magic(), 4.0f);
        }
    }
}

