/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.mixin;

import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityGravityMixin {
    @Inject(method={"shouldDiscardFriction"}, at={@At(value="RETURN")}, cancellable=true)
    public void onShouldDiscardFriction(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity livingEntity;
        if (!(!((LivingEntity)this).hasEffect(ReactiveMobEffects.NULL_GRAVITY) || (livingEntity = (LivingEntity)this) instanceof Player && (player = (Player)livingEntity).isShiftKeyDown())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getFrictionInfluencedSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void onGetFrictionInfluencedSpeed(CallbackInfoReturnable<Float> cir) {
        if (((LivingEntity)this).hasEffect(ReactiveMobEffects.NULL_GRAVITY)) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)this;
            cir.setReturnValue((Object)Float.valueOf(livingEntity instanceof Player && ((player = (Player)livingEntity).getDeltaMovement().length() > 10.0 || player.isShiftKeyDown()) ? 0.05f : 0.0f));
            ((LivingEntity)this).resetFallDistance();
        }
    }

    @Inject(method={"isVisuallySwimming"}, at={@At(value="RETURN")}, cancellable=true)
    public void isVisuallySwimming(CallbackInfoReturnable<Boolean> cir) {
        if (((LivingEntity)this).hasEffect(ReactiveMobEffects.NULL_GRAVITY)) {
            cir.setReturnValue((Object)true);
        }
    }
}

