/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.menu;

import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveMenus;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class DeskMenu
extends AbstractContainerMenu {
    final ContainerLevelAccess access;
    private static final int CONTAINER_SLOT_INDEX = 0;

    public DeskMenu(int containerId, Inventory player_inventory) {
        this(containerId, player_inventory, (IItemHandler)new ItemStackHandler(1), ContainerLevelAccess.NULL);
    }

    public DeskMenu(int containerId, Inventory player_inventory, IItemHandler desk_inventory, ContainerLevelAccess access) {
        super((MenuType)ReactiveMenus.DESK_MENU.get(), containerId);
        this.access = access;
        this.addSlot((Slot)new SlotItemHandler(desk_inventory, 0, 26, 25));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player_inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)player_inventory, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ReactiveBlocks.DESK.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int from_slot_index) {
        ItemStack to_stack = ItemStack.EMPTY;
        Slot from_slot = (Slot)this.slots.get(from_slot_index);
        if (from_slot.hasItem()) {
            ItemStack from_stack = from_slot.getItem();
            if (!from_stack.is((Item)ReactiveItems.MATERIAL.get())) {
                return ItemStack.EMPTY;
            }
            if (from_slot_index == 0 ? !this.moveItemStackTo(from_stack, 1, 37, false) : !this.moveItemStackTo(from_stack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (from_stack.isEmpty()) {
                from_slot.set(ItemStack.EMPTY);
            } else {
                from_slot.setChanged();
            }
        }
        return to_stack;
    }
}

