/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.components.BoundEntity;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.util.BeamHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpStaffItem
extends StaffItem {
    public WarpStaffItem(Block block, Item.Properties props, Item repair_item) {
        super(block, props, null, false, () -> 1, repair_item);
    }

    @Override
    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int ticks) {
    }

    @Override
    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity wielder) {
        return 0;
    }

    public static boolean hasBoundEntity(ItemStack stack) {
        return stack.has(ReactiveComponentTypes.BOUND_ENTITY);
    }

    @Nullable
    public Entity getBoundEntity(Level level, ItemStack stack) {
        if (!stack.has(ReactiveComponentTypes.BOUND_ENTITY)) {
            return null;
        }
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        return server.getEntity(Objects.requireNonNull((BoundEntity)stack.get(ReactiveComponentTypes.BOUND_ENTITY)).uuid());
    }

    public static void tryShowTutorial(Player user, ItemStack stack) {
        if (!stack.has(ReactiveComponentTypes.TUTORIAL_DONE)) {
            user.displayClientMessage((Component)Component.translatable((String)"message.reactive.warp_staff_tutorial"), true);
        }
    }

    private void zap(Player user, Vec3 target, ParticleOptions opt) {
        ParticleScribe.drawParticleZigZag(user.level(), opt, user.getEyePosition().x, user.getEyePosition().y - 0.4, user.getEyePosition().z, target.x, target.y, target.z, 5, 3, 0.4);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> hover_text, TooltipFlag tooltip_flag) {
        super.appendHoverText(stack, context, hover_text, tooltip_flag);
        if (WarpStaffItem.hasBoundEntity(stack)) {
            hover_text.add((Component)Component.translatable((String)"tooltip.reactive.entity_bound").append(Objects.requireNonNull((BoundEntity)stack.get(ReactiveComponentTypes.BOUND_ENTITY)).name()));
        } else {
            hover_text.add((Component)Component.translatable((String)"tooltip.reactive.no_entity_bound"));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity wielder, int tick, boolean unknown) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (WarpStaffItem.hasBoundEntity(stack)) {
            Entity bound = this.getBoundEntity(level, stack);
            if (bound != null) {
                ParticleScribe.drawExactParticleRing(level, (ParticleOptions)ParticleTypes.REVERSE_PORTAL, bound.position(), 0.5, 4);
                stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
            } else {
                stack.remove(ReactiveComponentTypes.BOUND_ENTITY);
            }
        } else {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        Vec3 end;
        ItemStack stack = user.getItemInHand(hand);
        EquipmentSlot slot = LivingEntity.getSlotForHand((InteractionHand)hand);
        if (WarpStaffItem.onLastDurability(stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        int range = (Integer)ConfigMan.COMMON.warpStaffRange.get();
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.level(), user, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, range);
        Vec3 blockHitPos = blockHit.getLocation();
        Vec3 start = user.getEyePosition();
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)user, (Vec3)start, (Vec3)(end = start.add(user.getLookAngle().scale((double)range))), (AABB)new AABB(start, end), Objects::nonNull, (double)Double.MAX_VALUE);
        Vec3 beam_end = entityHit == null ? blockHitPos : (entityHit.getLocation().distanceToSqr(start) < blockHitPos.distanceToSqr(start) ? entityHit.getLocation() : blockHitPos);
        if (user instanceof ServerPlayer) {
            if (!WarpStaffItem.hasBoundEntity(stack) && entityHit != null && entityHit.getEntity() instanceof LivingEntity) {
                if (entityHit.getEntity() instanceof ItemEntity || entityHit.getEntity() instanceof ExperienceOrb) {
                    entityHit.getEntity().teleportTo(user.position().x, user.position().y, user.position().z);
                    stack.hurtAndBreak(1, (LivingEntity)user, slot);
                    return InteractionResultHolder.success((Object)stack);
                }
                if (!((List)ConfigMan.COMMON.doNotTeleport.get()).contains(entityHit.getEntity().getEncodeId())) {
                    if (!((Boolean)ConfigMan.COMMON.warpStaffAffectsPlayers.get()).booleanValue() && entityHit.getEntity() instanceof Player) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    Entity entity = entityHit.getEntity();
                    if (entity instanceof EnderMan) {
                        EnderMan man = (EnderMan)entity;
                        man.hurt(user.damageSources().magic(), 1.0f);
                        man.setBeingStaredAt();
                        user.getCooldowns().addCooldown(stack.getItem(), 100);
                    } else {
                        String name = entity.hasCustomName() ? Objects.requireNonNull(entity.getCustomName()).getString() : entity.getName().getString();
                        stack.set(ReactiveComponentTypes.BOUND_ENTITY, (Object)new BoundEntity(name, entityHit.getEntity().getUUID()));
                        stack.set(ReactiveComponentTypes.TUTORIAL_DONE, (Object)Unit.INSTANCE);
                    }
                    this.zap(user, beam_end, (ParticleOptions)ParticleTypes.ENCHANTED_HIT);
                    level.playSound(null, beam_end.x, beam_end.y, beam_end.z, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.PLAYERS, 0.6f, 1.0f + user.level().random.nextFloat() * 0.2f);
                    level.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, entity.getEyePosition(), GameEvent.Context.of((Entity)entity));
                }
                stack.hurtAndBreak(1, (LivingEntity)user, slot);
                return InteractionResultHolder.success((Object)stack);
            }
            if (WarpStaffItem.hasBoundEntity(stack)) {
                Entity bound = this.getBoundEntity(level, stack);
                if (bound != null) {
                    bound.teleportTo(beam_end.x, beam_end.y, beam_end.z);
                    this.zap(user, beam_end, (ParticleOptions)ParticleTypes.REVERSE_PORTAL);
                    level.playSound(null, bound, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.gameEvent((Holder)GameEvent.TELEPORT, bound.getEyePosition(), GameEvent.Context.of((Entity)bound));
                }
                stack.remove(ReactiveComponentTypes.BOUND_ENTITY);
                stack.hurtAndBreak(1, (LivingEntity)user, slot);
                return InteractionResultHolder.success((Object)stack);
            }
            WarpStaffItem.tryShowTutorial(user, stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }
}

