/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.components.WarpBottleTarget;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.PowerBottleItem;
import dev.hyperlynx.reactive.items.QuartzBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WarpBottleItem
extends PowerBottleItem {
    public WarpBottleItem(Item.Properties props, Block block) {
        super(props, block);
    }

    public static ItemStack makeRiftBottle(CrucibleBlockEntity c, ItemStack bottle) {
        WarpBottleItem.setTeleportTarget(bottle, GlobalPos.of((ResourceKey)Objects.requireNonNull(c.getLevel()).dimension(), (BlockPos)c.getBlockPos()));
        c.enderRiftStrength = 0;
        return bottle;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return WarpBottleItem.isRiftBottle(stack) || super.isFoil(stack);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).is((Block)ReactiveBlocks.DIVINE_SYMBOL.get())) {
            return InteractionResult.FAIL;
        }
        if (WarpBottleItem.isRiftBottle(context.getItemInHand())) {
            return InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (WarpBottleItem.isRiftBottle(player.getItemInHand(hand))) {
            if (WarpBottleItem.attemptWarp(level, player, hand) && !player.isCreative()) {
                player.setItemInHand(hand, ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance());
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public static boolean attemptWarp(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        GlobalPos destination;
        boolean warp_occurred = false;
        ItemStack stack = player.getItemInHand(hand);
        if (level.dimension().equals(WarpBottleItem.getTeleportDimension(stack).orElse(null)) && (destination = WarpBottleItem.getTeleportPosition(stack)) != null) {
            if (CrystalIronItem.effectNotBlocked((LivingEntity)player, 1)) {
                player.teleportTo((double)destination.pos().getX() + 0.5, (double)destination.pos().getY() + 0.85, (double)destination.pos().getZ() + 0.5);
                level.playSound(null, destination.pos(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                warp_occurred = true;
                if (player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.BE_TELEPORTED.get())).trigger(splayer);
                }
            } else if (!(level instanceof ServerLevel)) {
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.warp_blocked"), true);
            }
        }
        return warp_occurred;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (WarpBottleItem.isRiftBottle(stack)) {
            return 1;
        }
        return super.getMaxStackSize(stack);
    }

    public static void setTeleportTarget(ItemStack stack, GlobalPos target) {
        stack.set((DataComponentType)ReactiveComponentTypes.WARP_BOTTLE_TARGET.get(), (Object)new WarpBottleTarget(target));
    }

    public static boolean isRiftBottle(ItemStack stack) {
        return stack.has((DataComponentType)ReactiveComponentTypes.WARP_BOTTLE_TARGET.value());
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return WarpBottleItem.isRiftBottle(stack) ? Component.translatable((String)"item.reactive.linked_warp_bottle") : super.getName(stack);
    }

    private static Optional<ResourceKey<Level>> getTeleportDimension(ItemStack stack) {
        if (stack.has((DataComponentType)ReactiveComponentTypes.WARP_BOTTLE_TARGET.get())) {
            return Optional.of(Objects.requireNonNull((WarpBottleTarget)stack.get((DataComponentType)ReactiveComponentTypes.WARP_BOTTLE_TARGET.get())).target().dimension());
        }
        return Optional.empty();
    }

    public static GlobalPos getTeleportPosition(ItemStack stack) {
        WarpBottleTarget target = (WarpBottleTarget)stack.get((DataComponentType)ReactiveComponentTypes.WARP_BOTTLE_TARGET.get());
        if (target == null) {
            return null;
        }
        return target.target();
    }
}

