/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class VortexStoneItem
extends Item {
    private static final double STRENGTH = 0.8;
    private static final double TOP_SPEED = 1.6;

    public VortexStoneItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Vec3 impulse = player.getLookAngle().scale(0.8);
        Vec3 new_movement = player.getDeltaMovement().add(impulse);
        if (player.hasEffect(ReactiveMobEffects.NULL_GRAVITY) && new_movement.length() > 1.6) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        player.setDeltaMovement(new_movement);
        player.resetFallDistance();
        level.playSound(null, player.blockPosition(), SoundEvents.BREEZE_CHARGE, SoundSource.PLAYERS, 1.0f, 0.95f + level.random.nextFloat() * 0.1f);
        level.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, player.getEyePosition(), GameEvent.Context.of((Entity)player));
        ParticleScribe.drawParticle(level, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, player.getX(), player.getY(), player.getZ());
        player.getCooldowns().addCooldown((Item)ReactiveItems.VORTEX_STONE.get(), ((Integer)ConfigMan.SERVER.vortexStoneCooldown.get()).intValue());
        if (!player.hasInfiniteMaterials()) {
            ItemStack stack = player.getItemInHand(hand);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (stack.getDamageValue() == stack.getMaxDamage() - 1) {
                player.setItemInHand(hand, Items.PACKED_ICE.getDefaultInstance());
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }
}

