/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.blocks.StardustBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StardustItem
extends Item {
    final int MAX_CHAIN_DEPTH = 10;

    public StardustItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        if (level.dimension().equals(Level.END)) {
            if (level.isClientSide) {
                for (int i = 0; i < 24; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.END_ROD, player.getX(), player.getY() + 1.5, player.getZ(), level.random.nextDouble() * 0.1 - 0.05, level.random.nextDouble() * 0.1 - 0.05, level.random.nextDouble() * 0.1 - 0.05);
                }
            }
        } else if (level.getBlockState(player.getOnPos().above(2)).isAir()) {
            StardustItem.place(level, player, player.getOnPos().above(2), hand);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private static void place(Level level, Player player, BlockPos pos, @NotNull InteractionHand hand) {
        level.setBlock(pos, ((StardustBlock)((Object)ReactiveBlocks.STARDUST.get())).defaultBlockState(), 2);
        if (!player.isCreative()) {
            player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (!level.getBlockState(pos = context.getClickedPos()).is((Block)ReactiveBlocks.STARDUST.get())) {
            return InteractionResult.PASS;
        }
        for (int i = 0; i < 10; ++i) {
            if (level.getBlockState(pos).is((Block)ReactiveBlocks.STARDUST.get())) {
                int x_displacement = WorldSpecificValue.get(String.valueOf(pos) + "x_displace", -5, 5);
                int y_displacement = WorldSpecificValue.get(String.valueOf(pos) + "y_displace", -3, 4);
                int z_displacement = WorldSpecificValue.get(String.valueOf(pos) + "z_displace", -5, 5);
                BlockPos new_pos = pos.offset(x_displacement, y_displacement, z_displacement);
                ParticleScribe.drawParticleLine(level, (ParticleOptions)ReactiveParticles.STARDUST, pos, new_pos, 5, 0.1);
                pos = new_pos;
                continue;
            }
            if (!level.getBlockState(pos).isAir()) continue;
            StardustItem.place(level, Objects.requireNonNull(context.getPlayer()), pos, context.getHand());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

