/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.be.StaffBlockEntity;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class StaffItem
extends BlockItem {
    final BiConsumer<Player, ItemStack> effectFunction;
    final boolean beam;
    private final Supplier<Integer> frequency;
    public final Item repair_item;

    public StaffItem(Block block, Item.Properties props, BiConsumer<Player, ItemStack> effect, boolean beam, Supplier<Integer> frequency, Item repair_item) {
        super(block, props);
        this.effectFunction = effect;
        this.beam = beam;
        this.repair_item = repair_item;
        this.frequency = frequency;
    }

    public static boolean onLastDurability(ItemStack stack) {
        return stack.getDamageValue() == stack.getMaxDamage() - 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int ticks) {
        if (StaffItem.onLastDurability(stack)) {
            return;
        }
        if (ticks % this.getFrequency(stack) == 1) {
            if (level.isClientSide && !this.beam) {
                this.effectFunction.accept((Player)player, stack);
            }
            if (!level.isClientSide) {
                level.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, player.getEyePosition(), GameEvent.Context.of((Entity)player));
                this.effectFunction.accept((Player)player, stack);
                if (player.getOffhandItem().is(stack.getItem())) {
                    player.getOffhandItem().hurtAndBreak(1, (ServerLevel)level, player, i -> {});
                } else {
                    player.getMainHandItem().hurtAndBreak(1, (ServerLevel)level, player, i -> {});
                }
            }
        }
        if (level.isClientSide && this.beam) {
            this.effectFunction.accept((Player)player, stack);
        }
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity wielder) {
        return 72000;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    private int getFrequency(@NotNull ItemStack stack) {
        MutableInt frequency = new MutableInt((Number)this.frequency.get());
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchant_level) -> {
            for (ConditionalEffect effect : ((Enchantment)enchant.value()).getEffects((DataComponentType)ReactiveComponentTypes.STAFF_RATE.value())) {
                frequency.setValue((Number)Float.valueOf(((EnchantmentValueEffect)effect.effect()).process(enchant_level, RandomSource.create(), (float)frequency.getValue().intValue())));
            }
        });
        return frequency.getValue();
    }

    public static void hurtVictim(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Entity victim, @NotNull DamageSource damage_source, float unmodified_damage) {
        victim.hurt(damage_source, StaffItem.getModifiedDamageOutput(player, stack, victim, damage_source, unmodified_damage));
    }

    private static float getModifiedDamageOutput(ServerPlayer player, @NotNull ItemStack stack, Entity target, DamageSource damage_source, float unmodified_damage) {
        return StaffItem.getModifiedDamageOutput(player.serverLevel(), stack, target, damage_source, unmodified_damage);
    }

    private static float getModifiedDamageOutput(ServerLevel server, @NotNull ItemStack stack, Entity target, DamageSource damage_source, float unmodified_damage) {
        MutableFloat strength = new MutableFloat(unmodified_damage);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchant_level) -> Enchantment.applyEffects((List)((Enchantment)enchant.value()).getEffects((DataComponentType)ReactiveComponentTypes.STAFF_DAMAGE.value()), (LootContext)Enchantment.damageContext((ServerLevel)server, (int)enchant_level, (Entity)target, (DamageSource)damage_source), effect -> strength.setValue(effect.process(enchant_level, server.random, strength.getValue().floatValue()))));
        return strength.getValue().floatValue();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (StaffItem.onLastDurability(player.getItemInHand(hand))) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        if (!player.isCrouching()) {
            player.startUsingItem(hand);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.SUCCESS;
        }
        if (context.getPlayer().isCrouching()) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean isValidRepairItem(ItemStack self, ItemStack repair_item_candidate) {
        return this.repair_item != null && repair_item_candidate.is(this.repair_item);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player placer, ItemStack stack, BlockState state) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return false;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!(blockentity instanceof StaffBlockEntity)) {
            return false;
        }
        StaffBlockEntity staff = (StaffBlockEntity)blockentity;
        staff.stack = stack.copy();
        return true;
    }
}

