/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.components.ReactionFlaskContents;
import dev.hyperlynx.reactive.entites.ThrownReactionFlask;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveEntityTypes;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ReactionFlaskItem
extends Item
implements ProjectileItem {
    public ReactionFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            ThrownReactionFlask flask = new ThrownReactionFlask(ReactiveEntityTypes.THROWN_REACTION_FLASK.get(), level);
            flask.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            flask.setOwner((Entity)player);
            flask.setItem(stack);
            flask.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)flask);
            ((FlagTrigger)((Object)ReactiveCriterionTriggers.THROW_FLASK.get())).trigger((ServerPlayer)player);
        }
        stack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.success((Object)stack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownReactionFlask flask = new ThrownReactionFlask(ReactiveEntityTypes.THROWN_REACTION_FLASK.get(), level);
        flask.setPos(new Vec3(pos.x(), pos.y(), pos.z()));
        flask.setItem(stack);
        return flask;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> hover_text, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, hover_text, tooltipFlag);
        if (!stack.has((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get())) {
            hover_text.add((Component)Component.translatable((String)"text.reactive.random").withStyle(ChatFormatting.LIGHT_PURPLE));
            return;
        }
        ReactionFlaskContents contents = (ReactionFlaskContents)stack.get((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get());
        assert (contents != null);
        MutableComponent power_readout = Component.empty();
        int counter = 0;
        Set<Power> powers = contents.powers().keySet();
        for (Power power : powers) {
            power_readout.append((Component)Component.literal((String)power.getName()).withColor(power.getColor().hex()));
            if (++counter == powers.size()) continue;
            power_readout.append(" + ");
        }
        if (!power_readout.getSiblings().isEmpty()) {
            hover_text.add((Component)power_readout);
        }
        if (contents.electric_charge()) {
            hover_text.add((Component)Component.translatable((String)"text.reactive.charged"));
        }
    }
}

