/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.DivineSymbolBlock;
import dev.hyperlynx.reactive.blocks.PowerBottleBlock;
import dev.hyperlynx.reactive.items.BasePowerBottle;
import dev.hyperlynx.reactive.items.QuartzBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class PowerBottleItem
extends BlockItem
implements BasePowerBottle {
    public static final int BOTTLE_COST = 600;

    public PowerBottleItem(Item.Properties props, Block block) {
        super(block, props);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)BasePowerBottle.DISPENSE_ITEM_BEHAVIOR);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance();
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).getBlock().equals(this.getBlock())) {
            BlockState clicked_state = context.getLevel().getBlockState(context.getClickedPos());
            if ((Integer)clicked_state.getValue((Property)PowerBottleBlock.BOTTLES) == 3) {
                return InteractionResult.PASS;
            }
            Level level = context.getLevel();
            BlockPos clicked_pos = context.getClickedPos();
            level.setBlock(context.getClickedPos(), (BlockState)clicked_state.setValue((Property)PowerBottleBlock.BOTTLES, (Comparable)Integer.valueOf((Integer)clicked_state.getValue((Property)PowerBottleBlock.BOTTLES) + 1)), 2);
            SoundType soundtype = clicked_state.getSoundType((LevelReader)level, clicked_pos, (Entity)context.getPlayer());
            if (context.getPlayer() != null) {
                level.playSound(context.getPlayer(), clicked_pos, this.getPlaceSound(clicked_state, level, clicked_pos, context.getPlayer()), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, clicked_pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)clicked_state));
                if (!context.getPlayer().getAbilities().instabuild) {
                    context.getItemInHand().shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (context.getLevel().getBlockState(context.getClickedPos()).getBlock() instanceof DivineSymbolBlock) {
            return InteractionResult.PASS;
        }
        if (!(context.getLevel().getBlockState(context.getClickedPos()).getBlock() instanceof CrucibleBlock)) {
            return super.useOn(context);
        }
        return this.tryAddToCrucible(context);
    }
}

