/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.entites.HoverQuilt;
import dev.hyperlynx.reactive.registration.ReactiveEntityTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PhantomQuiltItem
extends Item {
    public PhantomQuiltItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Vec3 summon_pos = context.getClickedPos().offset(context.getClickedFace().getNormal()).getCenter();
        HoverQuilt quilt = (HoverQuilt)ReactiveEntityTypes.HOVER_QUILT.get().create(level);
        if (quilt == null) {
            return InteractionResult.FAIL;
        }
        quilt.setPos(summon_pos);
        level.addFreshEntity((Entity)quilt);
        context.getItemInHand().consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        HoverQuilt quilt = (HoverQuilt)ReactiveEntityTypes.HOVER_QUILT.get().create(level);
        if (quilt == null) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        quilt.setPos(player.getEyePosition().add(player.getLookAngle().scale(1.5)));
        level.addFreshEntity((Entity)quilt);
        player.getItemInHand(hand).consume(1, (LivingEntity)player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }
}

