/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;

public class LightStaffItem
extends StaffItem {
    private static final int LIGHT_BREAK_RANGE = 24;

    public LightStaffItem(Block block, Item.Properties props, BiConsumer<Player, ItemStack> effect, boolean beam, Item repair_item) {
        super(block, props, effect, beam, (Supplier<Integer>)ConfigMan.COMMON.lightStaffFrequency, repair_item);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (LightStaffItem.onLastDurability(player.getItemInHand(hand))) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        if (!level.isClientSide) {
            level.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH, player.getEyePosition(), GameEvent.Context.of((Entity)player));
            this.effectFunction.accept(player, player.getItemInHand(hand));
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        return super.use(level, player, hand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        BlockPos light_to_break;
        Level level = entity.level();
        if (entity instanceof Player && (light_to_break = (BlockPos)BlockPos.findClosestMatch((BlockPos)entity.getOnPos(), (int)24, (int)24, pos -> level.getBlockState(pos).is((Block)ReactiveBlocks.GLOWING_AIR.get())).orElse(null)) != null) {
            level.setBlock(light_to_break, Blocks.AIR.defaultBlockState(), 2);
            ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.SMOKE, light_to_break, 0.5, 0.2, 5);
            level.playSound(null, light_to_break, SoundEvents.GENERIC_BURN, SoundSource.PLAYERS, 0.5f, 1.0f);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, entity.getEyePosition(), GameEvent.Context.of((Entity)entity));
        }
        return false;
    }
}

