/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.blocks.ChainDisplacingBlock;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class DisplacerItem
extends Item {
    public static final int DISPLACER_BASE_DISPLACE_TIME = 200;

    public DisplacerItem(Item.Properties props) {
        super(props.attributes(SwordItem.createAttributes((Tier)Tiers.STONE, (int)3, (float)-3.0f)));
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        EquipmentSlot slot = LivingEntity.getSlotForHand((InteractionHand)context.getHand());
        level.gameEvent((Holder)GameEvent.HIT_GROUND, context.getClickedPos(), GameEvent.Context.of((BlockState)context.getLevel().getBlockState(context.getClickedPos())));
        ItemStack stack = context.getItemInHand();
        boolean hyper_mode = EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)ReactiveComponentTypes.WORLD_PIERCER.value()));
        if (hyper_mode) {
            Optional<BlockPos> displaced_center = this.perform(context, level, pos, state, slot, 32, 400);
            if (displaced_center.isPresent()) {
                Direction.Axis perpendicular_axis = switch (context.getClickedFace().getAxis()) {
                    default -> throw new MatchException(null, null);
                    case Direction.Axis.X, Direction.Axis.Z -> Direction.Axis.Y;
                    case Direction.Axis.Y -> Direction.Axis.X;
                };
                Direction initial_direction = context.getClickedFace().getClockWise(perpendicular_axis);
                int extra_delay = 0;
                for (BlockPos pos_within_square : BlockPos.spiralAround((BlockPos)displaced_center.get(), (int)1, (Direction)context.getClickedFace().getClockWise(initial_direction.getAxis()), (Direction)initial_direction)) {
                    if (pos_within_square == displaced_center.get()) continue;
                    DisplacedBlock.displaceWithChain(level.getBlockState(pos_within_square), pos_within_square, level, 2 + extra_delay, 1, pos);
                    ++extra_delay;
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.perform(context, level, pos, state, slot, 8, 200).isPresent()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Optional<BlockPos> perform(UseOnContext context, Level level, BlockPos pos, BlockState state, EquipmentSlot slot, int max_depth, int displace_time) {
        BlockPos displace_pos = pos;
        if (state.getBlock() instanceof DisplacedBlock) {
            if (context.isInside()) {
                if (context.getPlayer() != null && context.getPlayer().getXRot() > 20.0f && !context.getClickedFace().equals((Object)Direction.UP)) {
                    displace_pos = displace_pos.below();
                }
                if (context.getPlayer() != null && context.getPlayer().getXRot() < -20.0f && !context.getClickedFace().equals((Object)Direction.DOWN)) {
                    displace_pos = displace_pos.above();
                }
            }
            BlockPos selected = displace_pos;
            for (int i = 0; i < max_depth; ++i) {
                if (level.getBlockState(selected = selected.offset(context.getClickedFace().getOpposite().getNormal())).getBlock() instanceof DisplacedBlock) continue;
                DisplacerItem.displace(level, selected, displace_time);
                Player player = context.getPlayer();
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer splayer = (ServerPlayer)player;
                if (context.getPlayer().isCreative()) break;
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)splayer, slot);
                break;
            }
            level.playSound(null, displace_pos, state.getBlock().getSoundType(state, (LevelReader)level, displace_pos, null).getHitSound(), SoundSource.PLAYERS, 1.0f, 1.1f);
            return Optional.of(selected);
        }
        boolean displace_worked = DisplacerItem.displace(level, displace_pos, displace_time);
        if (displace_worked) {
            level.playSound(null, displace_pos, state.getBlock().getSoundType(state, (LevelReader)level, displace_pos, null).getHitSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                if (!context.getPlayer().isCreative()) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)splayer, slot);
                }
            }
            return Optional.of(displace_pos);
        }
        level.playSound(null, displace_pos, state.getBlock().getSoundType(state, (LevelReader)level, displace_pos, null).getHitSound(), SoundSource.PLAYERS, 1.0f, 0.7f);
        return Optional.empty();
    }

    private static boolean displace(Level level, BlockPos selected, int displace_time) {
        Block block = level.getBlockState(selected).getBlock();
        if (block instanceof ChainDisplacingBlock) {
            ChainDisplacingBlock cdb = (ChainDisplacingBlock)block;
            cdb.breadthFirstDisplace(level, selected, level.getBestNeighborSignal(selected) > 0, displace_time);
            return true;
        }
        return DisplacedBlock.displace(level.getBlockState(selected), selected, level, displace_time);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity victim, LivingEntity wielder) {
        stack.hurtAndBreak(2, wielder, Objects.requireNonNull(stack.getEquipmentSlot()));
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean isValidRepairItem(ItemStack self, ItemStack repair_item_candidate) {
        return repair_item_candidate.is((Item)ReactiveItems.MOTION_SALT.get());
    }
}

