/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.OccultSymbolBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class AlchemyScrollItem
extends Item {
    public AlchemyScrollItem(Item.Properties props) {
        super(props.component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.getBlockState(context.getClickedPos()).is(Blocks.CAULDRON)) {
            if (level.isClientSide) {
                ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, context.getClickedPos(), 0.7, 0.9, 50);
            } else {
                level.setBlock(context.getClickedPos(), ((CrucibleBlock)((Object)ReactiveBlocks.CRUCIBLE.get())).defaultBlockState(), 2);
                level.playSound(null, context.getClickedPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 0.8f);
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.MAKE_CRUCIBLE.get())).trigger((ServerPlayer)context.getPlayer());
            }
            if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                context.getPlayer().setItemInHand(context.getHand(), Items.PAPER.getDefaultInstance());
            }
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockState(context.getClickedPos()).is((Block)ReactiveBlocks.OCCULT_SYMBOL.get()) && !((Boolean)level.getBlockState(context.getClickedPos()).getValue((Property)OccultSymbolBlock.ACTIVE)).booleanValue()) {
            if (level.isClientSide) {
                for (int i = 0; i < 10; ++i) {
                    level.addParticle((ParticleOptions)ReactiveParticles.SMALL_BLACK_RUNE, context.getClickLocation().x + level.random.nextDouble() * 0.5 - 0.25, context.getClickLocation().y + level.random.nextDouble() * 0.5 - 0.25, context.getClickLocation().z + level.random.nextDouble() * 0.5 - 0.25, 0.0, 0.0, 0.0);
                }
            } else {
                level.setBlock(context.getClickedPos(), (BlockState)level.getBlockState(context.getClickedPos()).setValue((Property)OccultSymbolBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                level.playSound(null, context.getClickedPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 0.74f);
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.OCCULT_AWAKENING.get())).trigger((ServerPlayer)context.getPlayer());
            }
            if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                context.getPlayer().setItemInHand(context.getHand(), Items.PAPER.getDefaultInstance());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

