/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TransmuteComponentProcessor
implements IComponentProcessor {
    private TransmuteRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipe_id = "reactive:transmutation/" + variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        RecipeManager manager = level.getRecipeManager();
        this.recipe = (TransmuteRecipe)((RecipeHolder)manager.byKey(ResourceLocation.parse((String)recipe_id)).orElseThrow()).value();
    }

    @Nullable
    public IVariable process(Level level, @NotNull String key) {
        if (this.recipe != null && key.equals("reactant")) {
            return IVariable.from((Object)this.recipe.getReactant().getItems(), (HolderLookup.Provider)level.registryAccess());
        }
        if (this.recipe != null && key.equals("product")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("reagents")) {
            if (this.recipe == null) {
                return IVariable.wrap((String)Component.translatable((String)"docs.reactive.removed_recipe").getString(), (HolderLookup.Provider)level.registryAccess());
            }
            ArrayList<String> reagent_list = new ArrayList<String>();
            for (Power reagent : this.recipe.getReagents()) {
                reagent_list.add(reagent.getName());
            }
            return IVariable.wrap((String)(Component.translatable((String)"docs.reactive.reagent_label").getString() + ((Object)reagent_list).toString().substring(1, ((Object)reagent_list).toString().length() - 1)), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

