/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MaterialCraftComponentProcessor
implements IComponentProcessor {
    private ItemStack base = ItemStack.EMPTY;
    private ItemStack result = ItemStack.EMPTY;

    public void setup(Level level, IVariableProvider variables) {
        this.base = (ItemStack)variables.get("base", (HolderLookup.Provider)level.registryAccess()).as(ItemStack.class);
        String output_material_id = variables.get("output_material", (HolderLookup.Provider)level.registryAccess()).asString();
        ResourceLocation output_material_rl = ResourceLocation.parse((String)output_material_id);
        if (MaterialMan.occupied(level, output_material_rl)) {
            this.result = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
            this.result.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)output_material_rl);
            YieldEntry yield = (YieldEntry)this.base.getItemHolder().getData(ReactiveDataMaps.MATERIAL_SALT_YIELDS);
            if (yield != null) {
                this.result.setCount(this.base.getCount() * yield.yield_per_input());
            }
        }
    }

    @Nullable
    public IVariable process(Level level, @NotNull String key) {
        switch (key) {
            case "reactant": {
                return IVariable.from((Object)this.base, (HolderLookup.Provider)level.registryAccess());
            }
            case "product": {
                return IVariable.from((Object)this.result, (HolderLookup.Provider)level.registryAccess());
            }
            case "info": {
                if (this.base == ItemStack.EMPTY) {
                    return IVariable.wrap((String)Component.translatable((String)"docs.reactive.invalid_base_material").getString(), (HolderLookup.Provider)level.registryAccess());
                }
                if (this.result != ItemStack.EMPTY) break;
                return IVariable.wrap((String)Component.translatable((String)"docs.reactive.invalid_material").getString(), (HolderLookup.Provider)level.registryAccess());
            }
        }
        return null;
    }
}

