/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs.events;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.integration.kubejs.KubeScriptException;
import dev.hyperlynx.reactive.integration.kubejs.ReactionFactory;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class KubeReactionConstructEvent
implements KubeEvent {
    final ReactionMan.ReactionConstructEvent event;

    public KubeReactionConstructEvent(ReactionMan.ReactionConstructEvent event) {
        this.event = event;
    }

    public ReactionFactory builder(String alias, MutableComponent custom_name, String ... reagent_locations) {
        Stream<Power> reagents = Arrays.stream(reagent_locations).map(location -> this.getPower(ResourceLocation.parse((String)location)));
        return new ReactionFactory(this.event.level, alias, custom_name, reagents.toList());
    }

    private Power getPower(ResourceLocation location) {
        try {
            return (Power)Powers.POWER_REGISTRY.get(location);
        }
        catch (NullPointerException e) {
            throw new KubeScriptException("Power " + String.valueOf(location) + " does not exist!");
        }
    }

    public void afterPosted(EventResult result) {
        ReactiveKubeJSPlugin.LOGGER.info("Finished constructing KubeJS reactions");
        ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.ingestReactionHandlers();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ReactiveKubeJSPlugin.ReactionAliasPayload(ReactiveKubeJSPlugin.CUSTOM_REACTION_ALIASES), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

