/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.client.ReactiveClientMod;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.integration.kubejs.CustomPowerBottleItem;
import dev.hyperlynx.reactive.integration.kubejs.CustomReaction;
import dev.hyperlynx.reactive.integration.kubejs.FlagTriggerBuilder;
import dev.hyperlynx.reactive.integration.kubejs.KubePowerBuilder;
import dev.hyperlynx.reactive.integration.kubejs.events.EventHandlerCache;
import dev.hyperlynx.reactive.integration.kubejs.events.EventTransceiver;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.plugin.ClassFilter;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ReactiveKubeJSPlugin
implements KubeJSPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Reactive/KubeJS Integration");
    public static final EventHandlerCache REACTION_EFFECT_CACHE = new EventHandlerCache();
    public static final Set<String> CUSTOM_REACTION_ALIASES = new HashSet<String>();

    public void registerBuilderTypes(BuilderTypeRegistry registry) {
        registry.addDefault(Powers.POWER_REGISTRY_KEY, KubePowerBuilder.class, KubePowerBuilder::new);
        registry.addDefault(Registries.TRIGGER_TYPE, FlagTriggerBuilder.class, FlagTriggerBuilder::new);
        registry.of(Registries.ITEM, reg -> reg.add("reactive:power_bottle", CustomPowerBottleItem.Builder.class, CustomPowerBottleItem.Builder::new));
    }

    public void registerEvents(EventGroupRegistry registry) {
        registry.register(EventTransceiver.EVENTS);
    }

    public void registerClasses(ClassFilter filter) {
        filter.allow(WorldSpecificValue.class);
        filter.allow(ParticleScribe.class);
    }

    public void registerBindings(BindingRegistry bindings) {
        bindings.add("WorldSpecificValue", WorldSpecificValue.class);
        bindings.add("ParticleScribe", ParticleScribe.class);
        bindings.add("ReactionMan", ReactionMan.class);
    }

    public static void registerPayloads(PayloadRegistrar registrar) {
        registrar.commonToClient(ReactionAliasPayload.TYPE, ReactionAliasPayload.STREAM_CODEC, (payload, _context) -> {
            LOGGER.debug("Received KubeJS reactions, registering them to renderer");
            ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.received_renderers = true;
            for (String alias : payload.aliases()) {
                ReactiveMod.LOGGER.debug("-> {}", (Object)alias);
                ReactiveClientMod.REACTION_RENDERERS.RENDERERS.put(alias, CustomReaction.getRenderFunction(alias));
            }
        });
        registrar.playToServer(ReactionAliasRequestPayload.TYPE, ReactionAliasRequestPayload.STREAM_CODEC, (payload, _context) -> {
            LOGGER.info("Sending KubeJS reaction aliases as requested");
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ReactionAliasPayload(CUSTOM_REACTION_ALIASES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public record ReactionAliasPayload(Set<String> aliases) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ReactionAliasPayload> TYPE = new CustomPacketPayload.Type(ReactiveMod.location("kubejs_reaction_aliases"));
        public static final StreamCodec<? super FriendlyByteBuf, ReactionAliasPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(HashSet::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), ReactionAliasPayload::aliases, ReactionAliasPayload::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ReactionAliasRequestPayload() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ReactionAliasRequestPayload> TYPE = new CustomPacketPayload.Type(ReactiveMod.location("kubejs_request_reaction_aliases"));
        public static final StreamCodec<? super FriendlyByteBuf, ReactionAliasRequestPayload> STREAM_CODEC = StreamCodec.unit((Object)new ReactionAliasRequestPayload());

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

