/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBuilder;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class KubePowerBuilder
extends BuilderBase<Power> {
    private final PowerBuilder builder;

    public KubePowerBuilder(ResourceLocation id) {
        super(id);
        this.builder = new PowerBuilder(id);
    }

    public Power createObject() {
        return this.builder.build();
    }

    public KubePowerBuilder color(int color) {
        this.builder.color(color);
        return this;
    }

    public KubePowerBuilder bottle(Item bottle) {
        this.builder.bottle(bottle);
        return this;
    }

    public KubePowerBuilder setNormalWater() {
        this.builder.water(Blocks.WATER);
        return this;
    }

    public KubePowerBuilder setMagicWater() {
        this.builder.water((Block)ReactiveBlocks.DUMMY_MAGIC_WATER.get());
        return this;
    }

    public KubePowerBuilder setFastWater() {
        this.builder.water((Block)ReactiveBlocks.DUMMY_FAST_WATER.get());
        return this;
    }

    public KubePowerBuilder setNoiseWater() {
        this.builder.water((Block)ReactiveBlocks.DUMMY_NOISE_WATER.get());
        return this;
    }

    public KubePowerBuilder setSlowWater() {
        this.builder.water((Block)ReactiveBlocks.DUMMY_SLOW_WATER.get());
        return this;
    }

    public KubePowerBuilder setCustomWater(Block water) {
        this.builder.water(water);
        return this;
    }

    public KubePowerBuilder setInvisible() {
        this.builder.invisible = true;
        return this;
    }

    public KubePowerBuilder setName(MutableComponent name) {
        this.builder.setName(name);
        return this;
    }
}

