/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei.bottles;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.items.QuartzBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PowerBottleRecipe
implements Recipe<RecipeInput> {
    protected final Ingredient bottle;
    protected final Power power;

    public PowerBottleRecipe(String ignored, Power power) {
        this.bottle = Ingredient.of((ItemStack[])new ItemStack[]{power.getBottle()});
        this.power = power;
    }

    public boolean matches(RecipeInput input, Level level) {
        return this.power.matchesBottle(input.getItem(0));
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.JEI_BOTTLE_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ReactiveRecipes.JEI_BOTTLE_RECIPE_TYPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance();
    }

    public boolean isSpecial() {
        return true;
    }

    public Power getPower() {
        return this.power;
    }
}

