/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.components.ReactionFlaskContents;
import dev.hyperlynx.reactive.integration.jei.DissolveRecipeCategory;
import dev.hyperlynx.reactive.integration.jei.HyperComposterRecipe;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientHandler;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientRenderer;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientType;
import dev.hyperlynx.reactive.integration.jei.TransmuteRecipeCategory;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipe;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipeCategory;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import dev.hyperlynx.reactive.items.SecretScaleItem;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.recipes.ReactionFlaskCraftingRecipe;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ReactiveJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPERS;
    public static final DissolveRecipeCategory DISSOLVE_CATEGORY;
    public static final TransmuteRecipeCategory TRANSMUTE_CATEGORY;
    public static final PowerBottleRecipeCategory POWER_BOTTLE_CATEGORY;
    public static final PowerIngredientType POWER_TYPE;
    public static final PowerIngredientHandler POWER_HANDLER;
    public static final PowerIngredientRenderer POWER_RENDERER;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ReactiveMod.location("jei_plugin");
    }

    private void setHelpers(IJeiHelpers helpers) {
        if (HELPERS == null) {
            HELPERS = helpers;
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.setHelpers(registration.getJeiHelpers());
        registration.addRecipeCategories(new IRecipeCategory[]{DISSOLVE_CATEGORY, TRANSMUTE_CATEGORY, POWER_BOTTLE_CATEGORY});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)POWER_TYPE, Powers.POWER_REGISTRY.stream().toList(), (IIngredientHelper)POWER_HANDLER, (IIngredientRenderer)POWER_RENDERER, Power.CODEC);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.setHelpers(registration.getJeiHelpers());
        ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
        registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get()));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ReactiveRecipes.TRANS_RECIPE_TYPE.get()));
        this.addDescriptions(registration);
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_BLAZE.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_LIFE.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_LIGHT.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_MIND.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_WARP.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)ReactiveItems.STAFF_OF_SOUL.get()), registration, registration.getVanillaRecipeFactory());
        this.addDisplacerRepairRecipe(registration, registration.getVanillaRecipeFactory());
        if (!((Boolean)ConfigMan.CLIENT.listPowersAsIngredients.get()).booleanValue()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)POWER_TYPE, Powers.POWER_REGISTRY.stream().toList());
        }
        this.addComposterRecipes(registration);
        this.addPowerBottleRecipes(registration);
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            this.addPowerSourceRecipes(registration);
        }
        this.addReactionFlaskRecipes(registration);
        this.addMaterialRecipes(registration);
    }

    private void addPowerBottleRecipes(IRecipeRegistration registration) {
        registration.addRecipes(POWER_BOTTLE_CATEGORY.getRecipeType(), Powers.POWER_REGISTRY.stream().map(power -> power.hasBottle() ? new PowerBottleRecipe("power_bottles", (Power)power) : null).filter(recipe -> recipe != null).toList());
    }

    private void addPowerSourceRecipes(IRecipeRegistration registration) {
        HashSet<Item> excluded = new HashSet<Item>();
        ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
        List purify_recipes = level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get());
        for (RecipeHolder r : purify_recipes) {
            for (ItemStack stack : ((DissolveRecipe)r.value()).getReactant().getItems()) {
                excluded.add(stack.getItem());
            }
        }
        for (ItemStack i : registration.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (Power.getSourcePower(i).isEmpty() || excluded.contains(i.getItem())) continue;
            registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), List.of(new RecipeHolder(ReactiveMod.location(i.getDescriptionId() + ".power_release_autogen"), (Recipe)new DissolveRecipe("power_source", Ingredient.of((ItemStack[])new ItemStack[]{i}), ItemStack.EMPTY, false))));
        }
    }

    private void addDescriptions(IRecipeRegistration registration) {
        registration.addItemStackInfo(((BlockItem)ReactiveItems.CRUCIBLE.get()).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.crucible")});
        registration.addItemStackInfo(((Item)ReactiveItems.SALT.get()).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((BlockItem)ReactiveItems.GOLD_FOAM.get()).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)ReactiveItems.MOTION_SALT.get()).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((SecretScaleItem)((Object)ReactiveItems.SECRET_SCALE.get())).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)ReactiveItems.PHANTOM_RESIDUE.get()).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.reaction_input")});
        this.addGenericDescriptions(registration, (Item)ReactiveItems.STAFF_OF_WARP.get(), (Item)ReactiveItems.STAFF_OF_MIND.get(), (Item)ReactiveItems.STAFF_OF_BLAZE.get(), (Item)ReactiveItems.STAFF_OF_LIFE.get(), (Item)ReactiveItems.STAFF_OF_LIGHT.get(), (Item)ReactiveItems.STAFF_OF_SOUL.get(), (Item)ReactiveItems.SOLID_PORTAL.get(), (Item)ReactiveItems.LIGHT_BOTTLE.get(), (Item)ReactiveItems.MIND_BOTTLE.get(), (Item)ReactiveItems.BODY_BOTTLE.get(), (Item)ReactiveItems.WARP_BOTTLE.get(), (Item)ReactiveItems.BLAZE_BOTTLE.get(), (Item)ReactiveItems.ACID_BOTTLE.get(), (Item)ReactiveItems.VERDANT_BOTTLE.get(), (Item)ReactiveItems.SOUL_BOTTLE.get(), (Item)ReactiveItems.VITAL_BOTTLE.get());
        this.addPowerDescriptions(registration);
    }

    private void addGenericDescriptions(IRecipeRegistration registration, Item ... items) {
        for (Item item : items) {
            registration.addItemStackInfo(item.getDefaultInstance(), new Component[]{Component.translatable((String)"jei.reactive.generic")});
        }
    }

    private void addPowerDescriptions(IRecipeRegistration registration) {
        for (Power power : Powers.POWER_REGISTRY.stream().toList()) {
            registration.addIngredientInfo((Object)power, (IIngredientType)POWER_TYPE, new Component[]{Component.translatable((String)"jei.reactive.power")});
        }
    }

    private void addStaffRepairRecipe(StaffItem staff, IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ItemStack full_durability = new ItemStack((ItemLike)staff);
        ItemStack three_quarters_durability = new ItemStack((ItemLike)staff);
        three_quarters_durability.setDamageValue(full_durability.getMaxDamage() / 4);
        ItemStack half_durability = new ItemStack((ItemLike)staff);
        half_durability.setDamageValue(full_durability.getMaxDamage() / 2);
        IJeiAnvilRecipe sacrifice_repair_recipe = factory.createAnvilRecipe(half_durability, List.of(half_durability), List.of(full_durability), ReactiveMod.location("staff_sacrifice_repair"));
        IJeiAnvilRecipe bottle_repair_recipe = factory.createAnvilRecipe(three_quarters_durability, List.of(new ItemStack((ItemLike)staff.repair_item)), List.of(full_durability), ReactiveMod.location("staff_bottle_repair"));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(sacrifice_repair_recipe, bottle_repair_recipe));
    }

    private void addComposterRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.COMPOSTING, List.of(new HyperComposterRecipe((Holder<Item>)ReactiveItems.VERDANT_BOTTLE), new HyperComposterRecipe((Holder<Item>)ReactiveItems.FLOWER_VINES)));
    }

    private void addDisplacerRepairRecipe(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        Item displacer = (Item)ReactiveItems.DISPLACER.get();
        ItemStack full_durability = new ItemStack((ItemLike)displacer);
        ItemStack three_quarters_durability = new ItemStack((ItemLike)displacer);
        three_quarters_durability.setDamageValue(full_durability.getMaxDamage() / 4);
        ItemStack half_durability = new ItemStack((ItemLike)displacer);
        half_durability.setDamageValue(full_durability.getMaxDamage() / 2);
        IJeiAnvilRecipe sacrifice_repair_recipe = factory.createAnvilRecipe(half_durability, List.of(half_durability), List.of(full_durability), ReactiveMod.location("displacer_sacrifice_repair"));
        IJeiAnvilRecipe bottle_repair_recipe = factory.createAnvilRecipe(three_quarters_durability, List.of(((Item)ReactiveItems.MOTION_SALT.get()).getDefaultInstance()), List.of(full_durability), ReactiveMod.location("displacer_salt_repair"));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(sacrifice_repair_recipe, bottle_repair_recipe));
    }

    private void addReactionFlaskRecipes(IRecipeRegistration registration) {
        Map<Character, Ingredient> alphabet = Map.of(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.INERT_CRYSTAL.get()}), Character.valueOf('b'), Ingredient.of(ReactionFlaskCraftingRecipe.POWER_BOTTLE_TAG), Character.valueOf('t'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.GOLD_THREAD.get()}));
        String top = " c ";
        String bottom = " t ";
        ItemStack result_flask = ((ReactionFlaskItem)((Object)ReactiveItems.REACTION_FLASK.get())).getDefaultInstance();
        result_flask.set((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get(), (Object)new ReactionFlaskContents(Map.of(), false));
        ItemStack result_flask_charged = result_flask.copy();
        result_flask_charged.set((DataComponentType)ReactiveComponentTypes.REACTION_FLASK_CONTENTS.get(), (Object)new ReactionFlaskContents(Map.of(), true));
        registration.addRecipes(RecipeTypes.CRAFTING, List.of(new RecipeHolder(ReactiveMod.location("special_crafting_recipe_flask_small"), (Recipe)new ShapedRecipe("reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, ShapedRecipePattern.of(alphabet, List.of(top, " b ", bottom)), result_flask)), new RecipeHolder(ReactiveMod.location("special_crafting_recipe_flask_medium"), (Recipe)new ShapedRecipe("reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, ShapedRecipePattern.of(alphabet, List.of(top, "bb ", bottom)), result_flask)), new RecipeHolder(ReactiveMod.location("special_crafting_recipe_flask_large"), (Recipe)new ShapedRecipe("reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, ShapedRecipePattern.of(alphabet, List.of(top, "bbb", bottom)), result_flask)), new RecipeHolder(ReactiveMod.location("special_crafting_recipe_flask_charge"), (Recipe)new ShapelessRecipe("reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, result_flask_charged, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{result_flask}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.VOLT_CELL.get()})})))));
    }

    private void addMaterialRecipes(IRecipeRegistration registration) {
        ItemStack salt_material_example = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        salt_material_example.set(ReactiveComponentTypes.MATERIAL_ID, (Object)ReactiveMod.location("example_salt"));
        salt_material_example.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.reactive.jei_material_tooltip"), Component.translatable((String)"text.reactive.jei_material_tooltip_1"), Component.translatable((String)"text.reactive.jei_material_tooltip_2"))));
        ItemStack adept_salt_material_example = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        adept_salt_material_example.set(ReactiveComponentTypes.MATERIAL_ID, (Object)ReactiveMod.location("example_adept_salt"));
        adept_salt_material_example.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.reactive.jei_material_tooltip"), Component.translatable((String)"text.reactive.jei_material_tooltip_1"), Component.translatable((String)"text.reactive.jei_material_tooltip_2"))));
        ItemStack creation_salt_material_example = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        creation_salt_material_example.set(ReactiveComponentTypes.MATERIAL_ID, (Object)ReactiveMod.location("example_creation_salt"));
        creation_salt_material_example.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.reactive.jei_material_tooltip"), Component.translatable((String)"text.reactive.jei_material_tooltip_1"), Component.translatable((String)"text.reactive.jei_material_tooltip_2"))));
        ItemStack wool_material_example = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        wool_material_example.set(ReactiveComponentTypes.MATERIAL_ID, (Object)ReactiveMod.location("example_wool"));
        wool_material_example.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.reactive.jei_material_tooltip"), Component.translatable((String)"text.reactive.jei_material_tooltip_1"), Component.translatable((String)"text.reactive.jei_material_tooltip_2"))));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), List.of(new RecipeHolder(ReactiveMod.location("material_crafting_demo.salt"), (Recipe)new TransmuteRecipe("material_crafting_demo", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.SALT_BLOCK.get()}), salt_material_example, List.of((Power)Powers.MIND_POWER.get()), 10, 10, false)), new RecipeHolder(ReactiveMod.location("material_crafting_demo.adept_salt"), (Recipe)new TransmuteRecipe("material_crafting_demo", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.ADEPT_SALT_BLOCK.get()}), adept_salt_material_example, List.of((Power)Powers.SOUL_POWER.get()), 10, 10, false)), new RecipeHolder(ReactiveMod.location("material_crafting_demo.creation_salt"), (Recipe)new TransmuteRecipe("material_crafting_demo", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReactiveItems.CREATION_SALT_BLOCK.get()}), creation_salt_material_example, List.of((Power)Powers.WARP_POWER.get()), 10, 10, false)), new RecipeHolder(ReactiveMod.location("material_crafting_demo.wool"), (Recipe)new TransmuteRecipe("material_crafting_demo", Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_WOOL}), wool_material_example, List.of((Power)Powers.FLOW_POWER.get()), 10, 10, false))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((BlockItem)ReactiveItems.CRUCIBLE.get()).getDefaultInstance(), new RecipeType[]{DISSOLVE_CATEGORY.getRecipeType()});
        registration.addRecipeCatalyst(((BlockItem)ReactiveItems.CRUCIBLE.get()).getDefaultInstance(), new RecipeType[]{TRANSMUTE_CATEGORY.getRecipeType()});
    }

    static {
        DISSOLVE_CATEGORY = new DissolveRecipeCategory();
        TRANSMUTE_CATEGORY = new TransmuteRecipeCategory();
        POWER_BOTTLE_CATEGORY = new PowerBottleRecipeCategory();
        POWER_TYPE = new PowerIngredientType();
        POWER_HANDLER = new PowerIngredientHandler();
        POWER_RENDERER = new PowerIngredientRenderer();
    }
}

