/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.util.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class PowerIngredientRenderer
implements IIngredientRenderer<Power> {
    public void render(GuiGraphics gui, Power ingredient) {
        TextureAtlasSprite sprite = PowerIngredientRenderer.getSprite(ingredient);
        Color color = ingredient.getColor();
        if (ingredient == Powers.ASTRAL_POWER.get()) {
            gui.fill(RenderType.END_GATEWAY, 0, 0, 16, 16, 0);
        } else if (!ingredient.invisible) {
            gui.fill(0, 0, 16, 16, 0xEE000000 | color.hex);
        }
        gui.blit(0, 0, 0, 16, 16, sprite, (float)color.red / 255.0f, (float)color.green / 255.0f, (float)color.blue / 255.0f, ingredient.invisible ? 0.2f : 1.0f);
    }

    public List<Component> getTooltip(Power ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add((Component)Component.literal((String)ingredient.getName()).append((Component)Component.translatable((String)"text.reactive.power")));
        if (tooltipFlag.isAdvanced()) {
            ret.add((Component)Component.literal((String)ingredient.getResourceLocation().toString()).withStyle(ChatFormatting.GRAY));
        }
        return ret;
    }

    public void getTooltip(ITooltipBuilder builder, @NotNull Power ingredient, @NotNull TooltipFlag tooltipFlag) {
        List<Component> tooltip = this.getTooltip(ingredient, tooltipFlag);
        builder.addAll(tooltip);
    }

    private static TextureAtlasSprite getSprite(Power power) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        return dispatcher.getBlockModel(power.getWaterRenderBlock().defaultBlockState()).getParticleIcon(ModelData.EMPTY);
    }
}

