/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entites.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.util.ReactiveVanillaCodecs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;

public record ReactorData(Map<Power, Integer> powers, List<ReactionStatusEntry> statuses) {
    public static final StreamCodec<FriendlyByteBuf, ReactorData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, Power.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), ReactorData::powers, (StreamCodec)ReactionStatusEntry.STREAM_CODEC.apply(ByteBufCodecs.list()), ReactorData::statuses, ReactorData::new);
    public static final Codec<ReactorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(Power.CODEC, (Codec)Codec.INT).xmap(ReactiveVanillaCodecs::makeMapMutable, ReactiveVanillaCodecs::doNothing).fieldOf("powers").forGetter(ReactorData::powers), (App)Codec.list(ReactionStatusEntry.CODEC).xmap(ReactiveVanillaCodecs::makeListMutable, ReactiveVanillaCodecs::doNothing).fieldOf("statuses").forGetter(ReactorData::statuses)).apply((Applicative)instance, ReactorData::new));

    public Tag toTag() {
        return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow();
    }

    public static ReactorData fromTag(CompoundTag tag) {
        DataResult result = CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (result.isError()) {
            return new ReactorData(new HashMap<Power, Integer>(), new ArrayList<ReactionStatusEntry>());
        }
        return (ReactorData)((Pair)result.getOrThrow()).getFirst();
    }

    public ReactorData copy() {
        return new ReactorData(new HashMap<Power, Integer>(this.powers), new ArrayList<ReactionStatusEntry>(this.statuses));
    }

    public static class Serializer
    implements EntityDataSerializer<ReactorData> {
        public StreamCodec<? super RegistryFriendlyByteBuf, ReactorData> codec() {
            return STREAM_CODEC;
        }

        public ReactorData copy(ReactorData value) {
            return new ReactorData(value.powers(), value.statuses());
        }
    }
}

