/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entites;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.components.ReactionFlaskContents;
import dev.hyperlynx.reactive.entites.ReactorEntity;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ThrownReactionFlask
extends ThrowableItemProjectile {
    public ThrownReactionFlask(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.level().playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS);
        ReactionFlaskContents contents = this.getItem().has(ReactiveComponentTypes.REACTION_FLASK_CONTENTS) ? (ReactionFlaskContents)this.getItem().get(ReactiveComponentTypes.REACTION_FLASK_CONTENTS) : new ReactionFlaskContents(Power.generateRandomPowerCombo(this.level()), false);
        if (contents == null) {
            return;
        }
        ReactorEntity entity = new ReactorEntity(ReactiveEntityTypes.REACTOR.get(), this.level());
        entity.setPos(result.getLocation().add(0.0, 1.0, 0.0));
        Map<Power, Integer> powers = contents.powers();
        entity.setLifespan(600);
        entity.setPowers(powers);
        entity.setElectricCharge(contents.electric_charge() ? 100 : 0);
        this.level().addFreshEntity((Entity)entity);
        for (Power power : powers.keySet()) {
            ParticleScribe.drawExactParticleRing(this.level(), (ParticleOptions)new EnergyParticle.Options(0.1f, power.getColor(), entity.position()), result.getLocation(), 0.2, 5);
        }
        this.kill();
    }

    protected Item getDefaultItem() {
        return (Item)ReactiveItems.REACTION_FLASK.get();
    }
}

