/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.datagen;

import dev.hyperlynx.reactive.advancements.ReactionTrigger;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.core.HolderLookup;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ReactionAdvancementGenerator
implements AdvancementProvider.AdvancementGenerator {
    private static final List<String> aliases = new ArrayList<String>();

    public static void add(String alias) {
        aliases.add(alias);
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        String REACTION_ADVANCEMENT_PREFIX = ":reactions/";
        for (String alias : aliases) {
            Advancement.Builder builder = Advancement.Builder.advancement();
            builder.addCriterion("criterion", ((ReactionTrigger)((Object)ReactiveCriterionTriggers.REACTION.get())).instance(alias));
            builder.requirements(AdvancementRequirements.Strategy.AND);
            builder.rewards(AdvancementRewards.EMPTY);
            builder.save(consumer, "reactive" + REACTION_ADVANCEMENT_PREFIX + alias);
            Advancement.Builder perfect_builder = Advancement.Builder.advancement();
            perfect_builder.addCriterion("criterion", ((ReactionTrigger)((Object)ReactiveCriterionTriggers.PERFECT_REACTION.get())).instance(alias));
            perfect_builder.requirements(AdvancementRequirements.Strategy.AND);
            perfect_builder.rewards(AdvancementRewards.EMPTY);
            perfect_builder.save(consumer, "reactive" + REACTION_ADVANCEMENT_PREFIX + alias + "_perfect");
        }
    }
}

