/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBearer;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.cmd.PowerArgumentType;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.net.MaterialRenameScreenPayload;
import dev.hyperlynx.reactive.registration.ReactiveCommandArguments;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="reactive")
public class ReactiveCommand {
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.reactive.no_player"));
    private static final SimpleCommandExceptionType ERROR_NO_CRUCIBLE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.reactive.no_crucible"));
    private static final SimpleCommandExceptionType ERROR_FAKE_POWER = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.reactive.fake_power"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command_builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reactive").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give_warp_bottle").then(Commands.argument((String)"target", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ReactiveCommand.giveWarpBottle((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("target", WorldCoordinates.class)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reaction").then(Commands.literal((String)"list").executes(context -> ReactiveCommand.listReactions((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"reload").executes(context -> ReactiveCommand.reloadReactions())))).then(((LiteralArgumentBuilder)Commands.literal((String)"power").then(Commands.literal((String)"add").then(Commands.argument((String)"crucible_location", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"power_id", (ArgumentType)PowerArgumentType.power()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> ReactiveCommand.modifyPower((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("crucible_location", WorldCoordinates.class), (ResourceLocation)context.getArgument("power_id", ResourceLocation.class), (Integer)context.getArgument("amount", Integer.class), false))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"crucible_location", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"power_id", (ArgumentType)PowerArgumentType.power()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> ReactiveCommand.modifyPower((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("crucible_location", WorldCoordinates.class), (ResourceLocation)context.getArgument("power_id", ResourceLocation.class), (Integer)context.getArgument("amount", Integer.class), true)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"material").then(Commands.literal((String)"give").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ReactiveCommand.giveMaterialBlockItem((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))))).then(Commands.literal((String)"rename").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).executes(context -> ReactiveCommand.openRenameScreen((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"id")))))).then(Commands.literal((String)"list").executes(context -> ReactiveCommand.printMaterials((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"reload").executes(context -> ReactiveCommand.reloadMaterials((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).then(Commands.literal((String)"confirm-delete").executes(context -> ReactiveCommand.removeMaterial((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"id"))))))).then(Commands.literal((String)"info").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).executes(context -> ReactiveCommand.printMaterialInfo((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"id")))))).then(Commands.literal((String)"remove-everything").then(Commands.literal((String)"confirm-delete").executes(ReactiveCommand::removeAllMaterials))));
        dispatcher.register(command_builder);
    }

    private static int reloadReactions() {
        ReactiveMod.REACTION_MAN.reset();
        return 1;
    }

    private static int modifyPower(CommandSourceStack source, WorldCoordinates crucible_location, ResourceLocation power_location, Integer amount, boolean remove) throws CommandSyntaxException {
        BlockPos pos = crucible_location.getBlockPos(source);
        ServerLevel level = source.getLevel();
        if (!level.isLoaded(pos)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        ArrayList<PowerBearer> bearers = new ArrayList<PowerBearer>();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PowerBearer) {
            PowerBearer be_bearer = (PowerBearer)blockEntity;
            bearers.add(be_bearer);
        }
        List bearer_entities = level.getEntities((Entity)null, new AABB(pos), entity -> entity instanceof PowerBearer);
        for (Entity entity2 : bearer_entities) {
            bearers.add((PowerBearer)entity2);
        }
        if (bearers.isEmpty()) {
            throw ERROR_NO_CRUCIBLE.create();
        }
        for (PowerBearer bearer : bearers) {
            Power power = (Power)Powers.POWER_REGISTRY.get(power_location);
            if (power == null) {
                throw ERROR_FAKE_POWER.create();
            }
            if (remove) {
                bearer.expendPower(power, amount);
                continue;
            }
            bearer.addPower(power, amount);
        }
        return 1;
    }

    private static int giveWarpBottle(CommandSourceStack source, WorldCoordinates target) throws CommandSyntaxException {
        ServerPlayer commander = source.getPlayer();
        if (commander == null) {
            throw ERROR_NO_PLAYER.create();
        }
        ItemStack bottle = ((WarpBottleItem)ReactiveItems.WARP_BOTTLE.get()).getDefaultInstance();
        WarpBottleItem.setTeleportTarget(bottle, GlobalPos.of((ResourceKey)commander.level().dimension(), (BlockPos)target.getBlockPos(source)));
        commander.addItem(bottle);
        return 1;
    }

    private static int listReactions(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.isPlayer()) {
            throw ERROR_NO_PLAYER.create();
        }
        List<String> aliases = ReactiveMod.REACTION_MAN.getReactionAliases((Level)source.getLevel());
        aliases.stream().sorted().forEach(alias -> {
            Reaction reaction = ReactiveMod.REACTION_MAN.get((Level)source.getLevel(), (String)alias);
            source.sendSuccess(() -> Component.literal((String)(alias + " : " + reaction.getName().getString())), true);
        });
        return 1;
    }

    private static int printMaterials(CommandSourceStack source) {
        source.sendSuccess(() -> Component.translatable((String)"commands.reactive.material_header"), true);
        List<Map.Entry> materials = MaterialMan.getAll((Level)source.getLevel()).entrySet().stream().sorted(Comparator.comparing(left -> ((ResourceLocation)left.getKey()).toString())).toList();
        for (Map.Entry material_entry : materials) {
            source.sendSuccess(() -> Component.literal((String)(((ResourceLocation)material_entry.getKey()).toString() + " - " + ((Material)material_entry.getValue()).getNameComponent().getString())), true);
        }
        return 1;
    }

    private static int removeMaterial(CommandContext<CommandSourceStack> context, ResourceLocation id) {
        if (!((Boolean)ConfigMan.SERVER.allowMaterialDeletion.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_removal_disabled"));
            return 0;
        }
        if (!MaterialMan.occupied((Level)((CommandSourceStack)context.getSource()).getLevel(), id)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_not_found"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.reactive.material_removed"), true);
        MaterialMan.remove((Level)((CommandSourceStack)context.getSource()).getLevel(), id);
        return 1;
    }

    private static int removeAllMaterials(CommandContext<CommandSourceStack> context) {
        if (!((Boolean)ConfigMan.SERVER.allowMaterialDeletion.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_removal_disabled"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.reactive.materials_reset"), true);
        MaterialMan.reset(((CommandSourceStack)context.getSource()).getLevel());
        return 1;
    }

    private static int giveMaterialBlockItem(CommandContext<CommandSourceStack> context, ResourceLocation material_id, int amount, ServerPlayer player) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_id_invalid"));
            return 0;
        }
        ItemStack stack = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)material_id);
        stack.setCount(amount);
        player.addItem(stack);
        return 1;
    }

    private static int printMaterialInfo(CommandContext<CommandSourceStack> context, ResourceLocation material_id) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_id_invalid"));
            return 0;
        }
        Material material = MaterialMan.fetch((Level)level, material_id);
        if (material == null) {
            ReactiveMod.LOGGER.error("Material {} was unexpectedly null when printing", (Object)material_id);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(material::getNameComponent, true);
        try {
            ((CommandSourceStack)context.getSource()).sendSuccess(material::formulaComponent, true);
        }
        catch (Exception e) {
            ReactiveMod.LOGGER.error("Caught an exception while creating formula component for [{}]: {}", (Object)material_id, (Object)e);
        }
        for (MaterialProperty<?> property : material.properties().keySet()) {
            ResourceLocation property_id = MaterialProperties.PROPERTY_REGISTRY.getKey(property);
            if (property_id == null) {
                ReactiveMod.LOGGER.error("Invalid property couldn't be printed");
                continue;
            }
            if (material.get(property) instanceof Unit) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)property_id.toLanguageKey("material_property")).withStyle(ChatFormatting.GRAY), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)property_id.toLanguageKey("material_property")).append(": ").append(material.get(property).toString()).withStyle(ChatFormatting.GRAY), true);
        }
        return 1;
    }

    private static int reloadMaterials(CommandSourceStack source) {
        MaterialMan.data((Level)source.getLevel()).addBuiltIns(source.getLevel());
        MaterialMan.data((Level)source.getLevel()).setDirty();
        source.sendSuccess(() -> Component.translatable((String)"message.reactive.reloaded_materials"), true);
        return 1;
    }

    private static int openRenameScreen(CommandContext<CommandSourceStack> context, ResourceLocation material_id) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.reactive.material_not_found"));
            return 0;
        }
        if (((CommandSourceStack)context.getSource()).getPlayer() == null) {
            return 0;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayer(), (CustomPacketPayload)new MaterialRenameScreenPayload(material_id), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        if (((Boolean)ConfigMan.COMMON.registerCommand.get()).booleanValue()) {
            ArgumentTypeInfos.registerByClass(PowerArgumentType.class, (ArgumentTypeInfo)((ArgumentTypeInfo)ReactiveCommandArguments.POWER_ARGUMENT.value()));
            ReactiveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }
}

