/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactorRenderer;
import dev.hyperlynx.reactive.entites.ReactorEntity;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ReactorEntityRenderer
extends EntityRenderer<ReactorEntity>
implements ReactorRenderer {
    public ReactorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ReactorEntity reactor, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)reactor, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        assert (Minecraft.getInstance().level != null);
        Map<Power, Integer> powers = reactor.reactorData().powers();
        for (Power power : powers.keySet()) {
            float chance = (float)powers.get(power).intValue() * 2.0f / (float)reactor.maxPower();
            if (!(Minecraft.getInstance().level.random.nextFloat() < chance)) continue;
            ParticleScribe.drawExactParticleSphere(reactor.level(), (ParticleOptions)new EnergyParticle.Options(power.getColor(), reactor.position()), reactor.position(), 0.0, 0.4, 1);
        }
        this.renderReactions(reactor);
        this.renderCharge(reactor);
    }

    private void renderCharge(ReactorEntity reactor) {
        if (reactor.getElectricCharge() > 0 && reactor.level().random.nextFloat() < 0.03f) {
            ParticleScribe.drawExactParticleSphere(reactor.level(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, reactor.position(), 0.0, 0.1, 1);
        }
    }

    public ResourceLocation getTextureLocation(ReactorEntity entity) {
        return null;
    }
}

