/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.hyperlynx.reactive.be.SymbolBlockEntity;
import dev.hyperlynx.reactive.blocks.SymbolBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.Property;

public class SymbolRenderer
implements BlockEntityRenderer<SymbolBlockEntity> {
    final ItemRenderer itemRenderer;

    public SymbolRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(SymbolBlockEntity symbol, float partialTicks, PoseStack pose_stack, MultiBufferSource mbs, int light, int overlay) {
        pose_stack.pushPose();
        if (((Direction)symbol.getBlockState().getValue((Property)SymbolBlock.FACING)).equals((Object)Direction.UP)) {
            pose_stack.translate(0.5, 0.02, 0.5);
            pose_stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (((Direction)symbol.getBlockState().getValue((Property)SymbolBlock.FACING)).equals((Object)Direction.DOWN)) {
            pose_stack.translate(0.5, 0.98, 0.5);
            pose_stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (((Direction)symbol.getBlockState().getValue((Property)SymbolBlock.FACING)).equals((Object)Direction.NORTH)) {
            pose_stack.translate(0.5, 0.5, 0.98);
        } else if (((Direction)symbol.getBlockState().getValue((Property)SymbolBlock.FACING)).equals((Object)Direction.SOUTH)) {
            pose_stack.translate(0.5, 0.5, 0.02);
        } else if (((Direction)symbol.getBlockState().getValue((Property)SymbolBlock.FACING)).equals((Object)Direction.EAST)) {
            pose_stack.translate(0.02, 0.5, 0.5);
            pose_stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else {
            pose_stack.translate(0.98, 0.5, 0.5);
            pose_stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        this.itemRenderer.renderStatic(symbol.symbol_item.getDefaultInstance(), ItemDisplayContext.FIXED, light, overlay, pose_stack, mbs, symbol.getLevel(), 0);
        pose_stack.popPose();
    }
}

