/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.ReactiveVanillaCodecs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ScalableParticleOptionsBase;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Vec3 target;
    private float speed = 0.05f;
    private final boolean reversed;
    private final boolean orbit;

    protected EnergyParticle(ClientLevel level, double x, double y, double z, Options options, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.target = options.getTarget();
        this.scale(options.getScale());
        this.rCol = (float)options.getColor().red / 255.0f;
        this.gCol = (float)options.getColor().green / 255.0f;
        this.bCol = (float)options.getColor().blue / 255.0f;
        this.hasPhysics = false;
        this.reversed = options.reverse_motion;
        this.orbit = options.orbit;
        this.setLifetime(this.reversed || this.orbit ? 20 : 200);
        this.setSpriteFromAge(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float p_172146_) {
        return LightTexture.pack((int)15, (int)15);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (!this.reversed && this.getPos().closerThan((Position)this.target, (double)(this.speed + 0.01f))) {
            this.remove();
        }
    }

    public void move(double x, double y, double z) {
        Vec3 move_step;
        Vec3 pos = this.getPos();
        if (this.orbit) {
            Vec3 normalized_toward_center = this.target.subtract(pos).normalize();
            Vec3 normalized_tangent = new Vec3(-normalized_toward_center.z, 0.0, normalized_toward_center.x);
            move_step = normalized_tangent.scale((double)this.speed);
        } else {
            move_step = this.target.subtract(pos).normalize().scale((double)this.speed);
        }
        if (this.reversed) {
            move_step = move_step.reverse();
        }
        super.move(move_step.x, move_step.y, move_step.z);
    }

    public static class Options
    extends ScalableParticleOptionsBase {
        final float speed;
        final Color color;
        final Vec3 target;
        final boolean reverse_motion;
        final boolean orbit;
        protected static final MapCodec<Options> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(Options::getSpeed), (App)Color.CODEC.fieldOf("color").forGetter(Options::getColor), (App)Vec3.CODEC.fieldOf("target").forGetter(Options::getTarget), (App)Codec.BOOL.fieldOf("reversed").forGetter(Options::isReversed), (App)Codec.BOOL.fieldOf("orbit").forGetter(Options::isOrbiting)).apply((Applicative)instance, Options::new));
        protected static final StreamCodec<RegistryFriendlyByteBuf, Options> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Options::getSpeed, Color.STREAM_CODEC, Options::getColor, ReactiveVanillaCodecs.VEC3_STREAM_CODEC, Options::getTarget, Options::new);

        public Options(Color color, Vec3 target) {
            this(0.05f, color, target);
        }

        public Options(float speed, Color color, Vec3 target) {
            this(speed, color, target, false);
        }

        public Options(float speed, Color color, Vec3 target, boolean reverse) {
            this(speed, color, target, reverse, false);
        }

        public Options(float speed, Color color, Vec3 target, boolean reverse, boolean orbit) {
            super(0.1f);
            this.speed = speed;
            this.color = color;
            this.target = target;
            this.reverse_motion = reverse;
            this.orbit = orbit;
        }

        @NotNull
        public ParticleType<?> getType() {
            return (ParticleType)ReactiveParticles.ENERGY_PARTICLE_TYPE.get();
        }

        public float getSpeed() {
            return this.speed;
        }

        public Color getColor() {
            return this.color;
        }

        public Vec3 getTarget() {
            return this.target;
        }

        public boolean isReversed() {
            return this.reverse_motion;
        }

        private boolean isOrbiting() {
            return this.orbit;
        }
    }

    public static class Provider
    implements ParticleProvider<Options> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(@NotNull Options options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnergyParticle particle = new EnergyParticle(level, x, y, z, options, this.sprites);
            particle.speed = options.getSpeed();
            return particle;
        }
    }

    public static class Type
    extends ParticleType<Options> {
        public Type() {
            super(false);
        }

        public MapCodec<Options> codec() {
            return Options.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec() {
            return Options.STREAM_CODEC;
        }
    }
}

