/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MaterialRenameScreen
extends Screen {
    final ResourceLocation material_to_rename;
    final EditBox name_box;
    final Button name_set_button;

    protected MaterialRenameScreen(ResourceLocation material_to_rename) {
        super((Component)Component.translatable((String)"ui.reactive.name_material_screen"));
        this.name_box = new EditBox(Minecraft.getInstance().font, 142, 20, (Component)Component.empty());
        this.material_to_rename = material_to_rename;
        this.name_set_button = new Button.Builder((Component)Component.translatable((String)"ui.reactive.discover_button"), button -> {
            ClientMaterialMan.rename(material_to_rename, this.name_box.getValue());
            Minecraft.getInstance().popGuiLayer();
        }).width(142).build();
    }

    protected void init() {
        super.init();
        this.name_box.setMaxLength(24);
        this.name_box.setHint(ClientMaterialMan.getName(this.material_to_rename));
        this.name_box.setPosition(this.width / 2 - this.name_box.getWidth() / 2, this.height / 2);
        this.addRenderableWidget((GuiEventListener)this.name_box);
        Material material = MaterialMan.fetch((Level)Minecraft.getInstance().level, this.material_to_rename);
        if (material != null && material.wasDiscovered()) {
            this.name_set_button.setMessage((Component)Component.translatable((String)"ui.reactive.rename_button"));
        }
        this.name_set_button.setPosition(this.width / 2 - this.name_set_button.getWidth() / 2, this.height / 2 + 25);
        this.name_set_button.active = false;
        this.addRenderableWidget((GuiEventListener)this.name_set_button);
    }

    public void tick() {
        this.name_set_button.active = !this.name_box.getValue().isEmpty();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (Minecraft.getInstance().level == null) {
            return;
        }
        ItemStack dummy_stack = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        dummy_stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)this.material_to_rename);
        graphics.pose().pushPose();
        graphics.pose().scale(4.0f, 4.0f, 4.0f);
        graphics.renderFakeItem(dummy_stack, this.width / 8 - 8, this.height / 8 - 17);
        graphics.pose().popPose();
    }
}

