/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.components.LitmusMeasurement;
import dev.hyperlynx.reactive.util.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.NotNull;

public class LitmusScreen
extends Screen {
    final LitmusMeasurement measurement;
    final List<Component> reaction_lines;
    private List<LitmusScreenComponent> lines_to_draw;
    int y = 0;
    int page = 0;
    int max_page = 0;
    private Button page_backward;
    private Button page_forward;
    private static final int BOX_WIDTH = 180;
    private static final int BOX_HEIGHT = 200;
    private final List<Color> decoration_colors = new ArrayList<Color>();
    static final int PAGE_LENGTH = 16;
    private static final ResourceLocation PAPER_BACKGROUND = ReactiveMod.location("textures/gui/litmus.png");
    private static final List<Rect> DECORATIONS = List.of(new Rect(28, 3, 44, 4), new Rect(127, 3, 135, 4), new Rect(8, 195, 15, 196), new Rect(90, 3, 99, 4), new Rect(135, 195, 151, 196), new Rect(123, 195, 133, 196), new Rect(80, 195, 89, 196), new Rect(44, 195, 52, 196), new Rect(164, 3, 171, 4), new Rect(105, 3, 109, 4));

    public LitmusScreen(LitmusMeasurement measurement, List<Component> reaction_lines) {
        super((Component)Component.translatable((String)"item.reactive.litmus_paper"));
        this.reaction_lines = reaction_lines;
        this.measurement = measurement;
        assert (Minecraft.getInstance().player != null);
    }

    private int getBoxCenterY() {
        return this.height / 2;
    }

    private int getBoxTopY() {
        return this.getBoxCenterY() - 100;
    }

    private int getBoxBottomY() {
        return this.getBoxCenterY() + 100;
    }

    private int getBoxCenterX() {
        return this.width / 2;
    }

    private int getBoxLeftX() {
        return this.getBoxCenterX() - 90;
    }

    private int getBoxRightX() {
        return this.getBoxCenterX() + 90;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        List<LitmusScreenComponent> lines = this.buildPowerText(this.measurement);
        lines.add(new LitmusScreenComponent((Component)Component.empty(), false, false));
        lines.add(new LitmusScreenComponent((Component)Component.translatable((String)"text.reactive.reaction_header").withStyle((Boolean)ConfigMan.COMMON.litmusScreen.get() != false ? ChatFormatting.BOLD : ChatFormatting.GRAY), false, true));
        lines.addAll(this.reaction_lines.stream().map(line -> new LitmusScreenComponent((Component)line, false, false)).toList());
        this.lines_to_draw = lines;
        this.page_backward = Button.builder((Component)Component.literal((String)"<"), LitmusScreen::pageBackward).build();
        this.page_backward.setWidth(20);
        this.page_backward.setPosition(this.getBoxLeftX() - this.page_backward.getWidth(), this.getBoxTopY() + 8);
        this.page_backward.visible = false;
        this.addRenderableWidget((GuiEventListener)this.page_backward);
        this.page_forward = Button.builder((Component)Component.literal((String)">"), LitmusScreen::pageForward).build();
        this.page_forward.setWidth(20);
        this.page_forward.setPosition(this.getBoxRightX(), this.getBoxTopY() + 8);
        this.page_forward.visible = false;
        this.addRenderableWidget((GuiEventListener)this.page_forward);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.page_forward.visible = this.page < this.max_page;
        this.page_backward.visible = this.page > 0;
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
        for (LitmusScreenLine line : this.paginate(this.lines_to_draw)) {
            this.renderLine(graphics, line.sequence, line.power_text);
        }
        this.renderDecorations(graphics);
        this.y = 0;
    }

    private void renderLine(GuiGraphics graphics, FormattedCharSequence sequence, boolean power_text) {
        int line_width = this.font.width(sequence);
        graphics.drawString(this.font, sequence, this.getBoxCenterX() - line_width / 2, this.getBoxTopY() + 20 + this.y, 0xFFFFFF, power_text);
        this.y += 10;
    }

    private List<LitmusScreenLine> paginate(List<LitmusScreenComponent> components) {
        this.max_page = (components.size() - 1) / 16;
        LinkedList<LitmusScreenLine> paginated = new LinkedList<LitmusScreenLine>();
        for (LitmusScreenComponent c : components) {
            if (c.component.equals((Object)Component.empty())) {
                paginated.add(new LitmusScreenLine(FormattedCharSequence.EMPTY, false, false));
                continue;
            }
            List lines = this.font.split((FormattedText)c.component, 180);
            for (FormattedCharSequence sequence : lines) {
                paginated.add(new LitmusScreenLine(sequence, c.power_text, c.header));
            }
        }
        for (int i = 0; i < this.page * 16; ++i) {
            if (((LitmusScreenLine)paginated.getFirst()).header && i == this.page * 16 - 1) continue;
            paginated.removeFirst();
        }
        while (paginated.size() > 16) {
            paginated.removeLast();
        }
        if (((LitmusScreenLine)paginated.getLast()).header) {
            paginated.removeLast();
        }
        return paginated;
    }

    private static void pageForward(Button ignored) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof LitmusScreen) {
            LitmusScreen lit_screen = (LitmusScreen)screen;
            if (lit_screen.page < lit_screen.max_page) {
                ++lit_screen.page;
            }
            lit_screen.y = 0;
        }
    }

    private static void pageBackward(Button ignored) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof LitmusScreen) {
            LitmusScreen lit_screen = (LitmusScreen)screen;
            if (lit_screen.page > 0) {
                --lit_screen.page;
            }
            lit_screen.y = 0;
        }
    }

    private List<LitmusScreenComponent> buildPowerText(LitmusMeasurement measurement) {
        ArrayList<LitmusScreenComponent> text = new ArrayList<LitmusScreenComponent>();
        text.add(new LitmusScreenComponent((Component)Component.translatable((String)"text.reactive.measurement_header").withStyle(ChatFormatting.BOLD), false, true));
        for (LitmusMeasurement.Line line : measurement.measurements()) {
            Power power;
            TextColor color = TextColor.fromRgb((int)0xFFFFFF);
            if (((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get()).booleanValue() && (power = (Power)Powers.POWER_REGISTRY.get(line.power())) != null) {
                color = power.getTextColor();
                if (this.decoration_colors.size() < DECORATIONS.size() && !power.invisible) {
                    if (power.equals(Powers.ASTRAL_POWER.get())) {
                        this.decoration_colors.add(new Color(-1));
                    } else {
                        this.decoration_colors.add(new Color(color.getValue()));
                    }
                }
            }
            text.add(new LitmusScreenComponent((Component)Component.literal((String)line.line()).withColor(color.getValue()), true, false));
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            ReactiveMod.LOGGER.error("Tried to produce litmus screen text with no player or level!");
            return List.of();
        }
        if (measurement.measurements().isEmpty()) {
            text.add(new LitmusScreenComponent((Component)Component.translatable((String)"text.reactive.measurement_empty").withStyle((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false ? Style.EMPTY.withColor(BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)player.getOnPos())) : Style.EMPTY), true, false));
        }
        if (measurement.integrity_violated()) {
            text.add(new LitmusScreenComponent((Component)Component.translatable((String)"text.reactive.litmus_integrity_failure").withStyle((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false ? ChatFormatting.RED : ChatFormatting.WHITE), true, false));
        }
        return text;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.fill(this.width / 2 - 90, this.getBoxTopY(), this.width / 2 + 90, this.getBoxTopY() + 200, 0x60606060);
        graphics.blit(PAPER_BACKGROUND, this.getBoxLeftX(), this.getBoxTopY(), 0, 0, 180, 224);
    }

    private void renderDecorations(GuiGraphics graphics) {
        for (int i = 0; i < this.decoration_colors.size(); ++i) {
            if (this.decoration_colors.get((int)i).hex == -1) {
                graphics.fill(RenderType.END_GATEWAY, this.getBoxLeftX(), this.getBoxTopY() + 2, this.getBoxLeftX() + 180, this.getBoxTopY() + 6, -1);
                graphics.fill(RenderType.END_GATEWAY, this.getBoxLeftX(), this.getBoxBottomY() - 6, this.getBoxLeftX() + 180, this.getBoxBottomY() - 2, -1);
                return;
            }
            Rect rect = DECORATIONS.get(i);
            graphics.fill(rect.x1 + this.getBoxLeftX(), rect.y1 + this.getBoxTopY(), rect.x2 + this.getBoxLeftX() + 1, rect.y2 + this.getBoxTopY() + 1, 0xFF000000 | this.decoration_colors.get((int)i).hex);
        }
    }

    record LitmusScreenComponent(Component component, boolean power_text, boolean header) {
    }

    record LitmusScreenLine(FormattedCharSequence sequence, boolean power_text, boolean header) {
    }

    private record Rect(int x1, int y1, int x2, int y2) {
    }
}

