/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.be.SymbolBlockEntity;
import dev.hyperlynx.reactive.blocks.WaterloggableBlock;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolBlock
extends WaterloggableBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private Item symbol_item = Items.BARRIER;
    protected static final VoxelShape UP_SHAPE = SymbolBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    protected static final VoxelShape DOWN_SHAPE = SymbolBlock.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape EAST_SHAPE = SymbolBlock.box((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_SHAPE = SymbolBlock.box((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape NORTH_SHAPE = SymbolBlock.box((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = SymbolBlock.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);

    public SymbolBlock(BlockBehaviour.Properties props) {
        super(props.pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.UP)) {
            return UP_SHAPE;
        }
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.DOWN)) {
            return DOWN_SHAPE;
        }
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.EAST)) {
            return EAST_SHAPE;
        }
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.WEST)) {
            return WEST_SHAPE;
        }
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.NORTH)) {
            return NORTH_SHAPE;
        }
        if (((Direction)state.getValue((Property)FACING)).equals((Object)Direction.SOUTH)) {
            return SOUTH_SHAPE;
        }
        System.err.println("Missing block state information for a symbol block at " + String.valueOf(pos) + "?!!");
        return UP_SHAPE;
    }

    public void setSymbolItem(Item item) {
        this.symbol_item = item;
    }

    @NotNull
    public Item asItem() {
        return this.symbol_item;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SymbolBlockEntity(pos, state, this.symbol_item);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

