/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import com.mojang.serialization.MapCodec;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RunestoneBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<RunestoneBlock> CODEC = RunestoneBlock.simpleCodec(RunestoneBlock::new);

    public RunestoneBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return WorldSpecificValue.get("rune_power", 0.36f, 0.56f);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Random random = new Random();
        int choice = random.nextInt(1, 4);
        if (choice == 1) {
            return (BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (choice == 2) {
            return (BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.WEST);
        }
        if (choice == 3) {
            return (BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        return (BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.SOUTH);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }
}

