/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.blocks.MnemonicBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class MindLichenBlock
extends GlowLichenBlock {
    public MindLichenBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).isCreative() && level.random.nextFloat() < 0.03f) {
            if (player.totalExperience > 0) {
                for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 3); ++i) {
                    Optional to_pos = this.getSpreader().spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, level.random);
                    if (!to_pos.isPresent()) continue;
                    player.giveExperiencePoints(-1);
                    level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.02f, 0.7f + level.random.nextFloat() * 0.1f);
                    if (!((double)level.random.nextFloat() < 0.1)) continue;
                    level.setBlock(((MultifaceSpreader.SpreadPos)to_pos.get()).pos(), ((MnemonicBlock)((Object)ReactiveBlocks.MNEMONIC_BULB.get())).defaultBlockState(), 2);
                }
            }
            return;
        }
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            this.getSpreader().spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, level.random);
            --orb.value;
            if (orb.value == 0) {
                orb.kill();
            }
        }
    }
}

