/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.be.MaterialBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.net.MaterialBESyncPayload;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MaterialBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<MaterialModel> MODEL = EnumProperty.create((String)"model", MaterialModel.class);
    public static final BooleanProperty RANDOM_TICKING = BooleanProperty.create((String)"random_ticking");
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light", (int)0, (int)15);

    public MaterialBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion().lightLevel(state -> (Integer)state.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(MODEL, (Comparable)((Object)MaterialModel.SALT))).setValue((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODEL});
        builder.add(new Property[]{RANDOM_TICKING});
        builder.add(new Property[]{LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MaterialBlockEntity(pos, state);
    }

    private BlockState setStateByMaterialId(Level level, BlockState state, ResourceLocation material_id) {
        Material material = MaterialMan.fetch(level, material_id);
        String model_name = material.getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "salt");
        int light_level = material.getOrDefault((MaterialProperty)MaterialProperties.LIGHT.get(), 0);
        return (BlockState)((BlockState)state.setValue(MODEL, (Comparable)((Object)MaterialModel.fromName(model_name)))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light_level));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState to_place_state = state;
        if (stack.has(ReactiveComponentTypes.MATERIAL_ID)) {
            ResourceLocation material_id = (ResourceLocation)stack.get(ReactiveComponentTypes.MATERIAL_ID);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MaterialBlockEntity) {
                MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
                mbe.setMaterial(level, material_id);
                if (level instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)slevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new MaterialBESyncPayload(mbe.getMaterialId(), pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            to_place_state = this.setStateByMaterialId(level, to_place_state, material_id);
            to_place_state = this.setRandomTicking(level, to_place_state, material_id);
            level.setBlock(pos, to_place_state, 2);
        }
    }

    private Material material(BlockGetter getter, BlockPos pos) {
        BlockEntity entity = getter.getBlockEntity(pos);
        if (!(entity instanceof MaterialBlockEntity)) {
            return Material.empty();
        }
        MaterialBlockEntity material_entity = (MaterialBlockEntity)entity;
        return material_entity.getMaterial();
    }

    private boolean isGelBlock(BlockState state) {
        return ((MaterialModel)((Object)state.getValue(MODEL))).equals((Object)MaterialModel.GEL);
    }

    private boolean isIntangible(BlockGetter getter, BlockPos pos, @Nullable Entity collider) {
        if (collider != null && this.material(getter, pos).has((MaterialProperty)MaterialProperties.SEMITANGIBLE.get())) {
            return collider.isShiftKeyDown();
        }
        return this.material(getter, pos).has((MaterialProperty)MaterialProperties.INTANGIBLE.get());
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Entity collider = null;
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entity_context = (EntityCollisionContext)context;
            collider = entity_context.getEntity();
        }
        if (this.isGelBlock(state) || this.isIntangible(getter, pos, collider)) {
            return Shapes.empty();
        }
        return Shapes.block();
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.isIntangible((BlockGetter)level, pos, entity)) {
            return;
        }
        living.makeStuckInBlock(state, this.isGelBlock(state) ? new Vec3((double)0.9f, 0.9, (double)0.9f) : new Vec3((double)0.4f, 0.4, (double)0.4f));
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.MAGMA_STEP.get())) {
            MaterialBlock.hurtWithMagmaStep(level, entity);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        MaterialBlockEntity mbe = (MaterialBlockEntity)level.getBlockEntity(pos);
        if (mbe == null || mbe.hasNoValidMaterial()) {
            return ((BlockItem)ReactiveItems.SALT_BLOCK.get()).getDefaultInstance();
        }
        stack.set(ReactiveComponentTypes.MATERIAL_ID, (Object)mbe.getMaterialId());
        return stack;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        BlockEntity entity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (entity instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)entity;
            if (mbe.hasNoValidMaterial()) {
                return List.of(((BlockItem)ReactiveItems.SALT_BLOCK.get()).getDefaultInstance());
            }
            ItemStack stack = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
            stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)mbe.getMaterialId());
            return List.of(stack);
        }
        return super.getDrops(state, params);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity victim) {
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.MAGMA_STEP.get())) {
            MaterialBlock.hurtWithMagmaStep(level, victim);
        }
    }

    private static void hurtWithMagmaStep(Level level, Entity victim) {
        if (!victim.isSteppingCarefully() && victim instanceof LivingEntity) {
            victim.hurt(level.damageSources().hotFloor(), 1.0f);
        }
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return super.isFireSource(state, level, pos, direction) || this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.FIRE_SOURCE.get());
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        float speed;
        BlockEntity blockEntity;
        Material material = this.material(getter, pos);
        Level level = player.level();
        if (!level.isClientSide && this.material(getter, pos).has((MaterialProperty)MaterialProperties.SELF_DEFENSE.get()) && (blockEntity = getter.getBlockEntity(pos)) instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
            if (mbe.generic_delay == 0) {
                Vec3 center = pos.getCenter();
                ParticleScribe.drawParticle(level, (ParticleOptions)ParticleTypes.ANGRY_VILLAGER, center.x + (double)level.random.nextFloat() - 0.5, center.y, center.z + (double)level.random.nextFloat() - 0.5);
                float damage = ((Float)material.get((MaterialProperty)MaterialProperties.SELF_DEFENSE.get())).floatValue();
                player.hurt(level.damageSources().magic(), damage);
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.ACID_BUBBLE, center.x, center.y, center.z, player.getX(), (double)(player.getEyeHeight() / 2.0f) + player.getY(), player.getZ(), 5, 10, 0.3);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, 0.5f, 0.98f + player.level().random.nextFloat() * 0.05f);
                mbe.generic_delay = 20;
            } else {
                --mbe.generic_delay;
            }
        }
        if ((speed = material.getOrDefault((MaterialProperty)MaterialProperties.BREAK_STRENGTH.get(), Float.valueOf(1.0f)).floatValue()) == -1.0f) {
            return 0.0f;
        }
        int neo_check = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)getter, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / (speed *= 0.75f) / (float)neo_check;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.BLAST_RESISTANCE.get(), Float.valueOf(1.0f)).floatValue();
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.ENCHANT_POWER.get(), Float.valueOf(0.0f)).floatValue();
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return super.getFriction(state, level, pos, entity) * this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.FRICTION.get(), Float.valueOf(1.0f)).floatValue();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.FLAMMABILITY.get(), 0);
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.REDSTONE.get(), 0);
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return MaterialModel.fromName(this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "salt")).getSoundType();
    }

    public static int getBlockColor(@NotNull BlockAndTintGetter getter, BlockPos pos) {
        BlockEntity entity = getter.getBlockEntity(pos);
        if (!(entity instanceof MaterialBlockEntity)) {
            return 0;
        }
        MaterialBlockEntity mbe = (MaterialBlockEntity)entity;
        Color color = mbe.getMaterial().getOrDefault((MaterialProperty)MaterialProperties.COLOR.get(), Color.white());
        return color.hex;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)RANDOM_TICKING);
    }

    private BlockState setRandomTicking(Level level, BlockState state, ResourceLocation material_id) {
        if (MaterialMan.fetch(level, material_id).has((MaterialProperty)MaterialProperties.WARPING.get())) {
            return (BlockState)state.setValue((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.WARPING.get())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(false)), 2);
            return;
        }
        for (Direction direction : Direction.allShuffled((RandomSource)level.random)) {
            BlockPos adjacent_pos = pos.offset(new Vec3i(direction.getStepX(), direction.getStepY(), direction.getStepZ()));
            BlockState adjacent_state = level.getBlockState(adjacent_pos);
            if (!adjacent_state.isAir() && !adjacent_state.is(Blocks.FIRE) && !adjacent_state.canBeReplaced()) continue;
            level.setBlock(adjacent_pos, state, 2);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MaterialBlockEntity) {
                MaterialBlockEntity old_mbe = (MaterialBlockEntity)blockEntity;
                blockEntity = level.getBlockEntity(adjacent_pos);
                if (blockEntity instanceof MaterialBlockEntity) {
                    MaterialBlockEntity new_mbe = (MaterialBlockEntity)blockEntity;
                    new_mbe.setMaterial((Level)level, old_mbe.getMaterialId());
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(adjacent_pos), (CustomPacketPayload)new MaterialBESyncPayload(old_mbe.getMaterialId(), adjacent_pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            level.removeBlock(pos, false);
            level.playSound(null, pos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS);
            float f = level.random.nextFloat() * 0.6f + 0.4f;
            ParticleScribe.drawParticleBox((Level)level, (ParticleOptions)new DustParticleOptions(new Vector3f(f * 0.9f, f * 0.3f, f), 0.5f), new AABB(pos), 8);
            return;
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.REDSTONE_MELTING.get())) {
            if (level.getDirectSignalTo(pos) > 0) {
                level.setBlock(pos, (BlockState)state.setValue(MODEL, (Comparable)((Object)MaterialModel.GEL)), 2);
            } else {
                level.setBlock(pos, (BlockState)state.setValue(MODEL, (Comparable)((Object)MaterialModel.valueOf(((String)this.material((BlockGetter)level, pos).get((MaterialProperty)MaterialProperties.MODEL_NAME.get())).toUpperCase()))), 2);
            }
        }
    }
}

