/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.be.GravityChandelierBlockEntity;
import dev.hyperlynx.reactive.blocks.WaterloggableBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GravityChandelierBlock
extends WaterloggableBlock
implements EntityBlock {
    public static final BooleanProperty OFFSET = BooleanProperty.create((String)"offset");
    public static final BooleanProperty SHOW_RADIUS = BooleanProperty.create((String)"show_radius");

    public GravityChandelierBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OFFSET, (Comparable)Boolean.valueOf(true))).setValue((Property)SHOW_RADIUS, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SHOW_RADIUS, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SHOW_RADIUS) == false)), 2);
            level.playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.2f);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)OFFSET, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)OFFSET) == false)), 2);
            level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, 0.72f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OFFSET});
        builder.add(new Property[]{SHOW_RADIUS});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GravityChandelierBlockEntity(pos, state);
    }

    @Nullable
    public <GravityChandelierBlockEntity extends BlockEntity> BlockEntityTicker<GravityChandelierBlockEntity> getTicker(Level level, BlockState state, BlockEntityType<GravityChandelierBlockEntity> t) {
        if (t == ReactiveBlockEntityTypes.GRAVITY_CHANDELIER.get()) {
            return (l, p, s, a) -> GravityChandelierBlockEntity.tick(l, p);
        }
        return null;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        level.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        if (!((Boolean)state.getValue((Property)SHOW_RADIUS)).booleanValue()) {
            return;
        }
        BlockPos center = (Boolean)state.getValue((Property)OFFSET) != false ? pos.above(10) : pos;
        ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.END_ROD, center, 0.0, 10.0, 30);
    }
}

