/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import com.mojang.serialization.MapCodec;
import dev.hyperlynx.reactive.be.GravityBeamBlockEntity;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GravityBeamBlock
extends DirectionalBlock
implements EntityBlock {
    public static final MapCodec<GravityBeamBlock> CODEC = GravityBeamBlock.simpleCodec(GravityBeamBlock::new);
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public GravityBeamBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{ENABLED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbor, BlockPos neighbor_position, boolean unknown) {
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GravityBeamBlockEntity(pos, state);
    }

    @Nullable
    public <GravityBeamBlockEntity extends BlockEntity> BlockEntityTicker<GravityBeamBlockEntity> getTicker(Level level, BlockState state, BlockEntityType<GravityBeamBlockEntity> t) {
        if (t == ReactiveBlockEntityTypes.GRAVITY_BEAM.get()) {
            return (l, p, s, a) -> GravityBeamBlockEntity.tick(l, p, s);
        }
        return null;
    }
}

