/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.blocks.ChainDisplacingBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FramedMotionSaltBlock
extends Block
implements ChainDisplacingBlock {
    public static final BooleanProperty POWERED = ObserverBlock.POWERED;

    public FramedMotionSaltBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState prior, boolean p_60570_) {
        if (level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get())) {
            ((FramedMotionSaltBlock)ReactiveBlocks.FRAMED_MOTION_SALT_BLOCK.get()).breadthFirstDisplace(level, pos, level.getBestNeighborSignal(pos) > 10);
        }
    }

    public void neighborChanged(BlockState our_state, Level level, BlockPos salt_pos, Block block, BlockPos neighbor_pos, boolean unknown) {
        if (level.getBestNeighborSignal(salt_pos) > 10) {
            level.setBlock(salt_pos, (BlockState)our_state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (((Boolean)our_state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(salt_pos, (BlockState)our_state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
        FramedMotionSaltBlock.checkBecomeElectrified(level, salt_pos, our_state, neighbor_pos);
    }

    private static void checkBecomeElectrified(Level level, BlockPos salt_pos, BlockState our_state, BlockPos neighbor_pos) {
        if (level.getBlockState(neighbor_pos).is((Block)ReactiveBlocks.VOLT_CELL.get()) && salt_pos.below().equals((Object)neighbor_pos)) {
            ((FramedMotionSaltBlock)ReactiveBlocks.FRAMED_MOTION_SALT_BLOCK.get()).breadthFirstDisplace(level, salt_pos, (Boolean)our_state.getValue((Property)POWERED));
        }
    }

    @Override
    public boolean stateMatchesSelf(BlockState state) {
        return state.is((Block)ReactiveBlocks.FRAMED_MOTION_SALT_BLOCK.get());
    }
}

